/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.IOUtils;
import ch.cern.sparkmeasure.StageVals;
import ch.cern.sparkmeasure.TaskVals;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.fasterxml.jackson.module.scala.experimental.ScalaObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class IOUtils$ {
    public static IOUtils$ MODULE$;
    private final ObjectMapper objectMapper;
    private final ObjectWriter objectWriter;

    static {
        new IOUtils$();
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public ObjectWriter objectWriter() {
        return this.objectWriter;
    }

    public <T> ListBuffer<T> readSerialized(String metricsFileName) {
        ListBuffer listBuffer;
        String fullPath = metricsFileName;
        try (IOUtils.ObjectInputStreamWithCustomClassLoader ois = new IOUtils.ObjectInputStreamWithCustomClassLoader(new FileInputStream(fullPath));){
            listBuffer = (ListBuffer)ois.readObject();
        }
        return listBuffer;
    }

    public void writeSerialized(String fullPath, Object metricsData) {
        try (ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(fullPath));){
            os.writeObject(metricsData);
        }
    }

    public ListBuffer<StageVals> readSerializedStageMetrics(String stageMetricsFileName) {
        return this.readSerialized(stageMetricsFileName);
    }

    public ListBuffer<TaskVals> readSerializedTaskMetrics(String stageMetricsFileName) {
        return this.readSerialized(stageMetricsFileName);
    }

    public void writeSerializedJSON(String fullPath, Object metricsData) {
        try (FileOutputStream os = new FileOutputStream(fullPath);){
            this.objectWriter().writeValue((OutputStream)os, metricsData);
        }
    }

    public void writeSerializedJSONToHadoop(String fullPath, Object metricsData, SparkConf conf) {
        URI fullPathUri = URI.create(fullPath);
        Path hdfswritepath = new Path(fullPath);
        Configuration hadoopConf = new Configuration();
        String keyId = System.getenv("AWS_ACCESS_KEY_ID");
        String accessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        if (keyId != null && accessKey != null) {
            hadoopConf.set("fs.s3.awsAccessKeyId", keyId);
            hadoopConf.set("fs.s3n.awsAccessKeyId", keyId);
            hadoopConf.set("fs.s3a.access.key", keyId);
            hadoopConf.set("fs.s3.awsSecretAccessKey", accessKey);
            hadoopConf.set("fs.s3n.awsSecretAccessKey", accessKey);
            hadoopConf.set("fs.s3a.secret.key", accessKey);
            String sessionToken = System.getenv("AWS_SESSION_TOKEN");
            if (sessionToken != null) {
                hadoopConf.set("fs.s3a.session.token", sessionToken);
            }
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)IOUtils$.$anonfun$writeSerializedJSONToHadoop$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)IOUtils$.$anonfun$writeSerializedJSONToHadoop$2(x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            IOUtils$.$anonfun$writeSerializedJSONToHadoop$3(hadoopConf, x$2);
            return BoxedUnit.UNIT;
        });
        String serializedMetrics = this.writeToStringSerializedJSON(metricsData);
        FileSystem fs = FileSystem.get((URI)fullPathUri, (Configuration)hadoopConf);
        try (FSDataOutputStream outputStream = fs.create(hdfswritepath);){
            outputStream.writeBytes(serializedMetrics);
        }
    }

    public String writeToStringSerializedJSON(Object metricsData) {
        return this.objectWriter().writeValueAsString(metricsData);
    }

    public List<StageVals> readSerializedStageMetricsJSON(String stageMetricsFileName) {
        List list;
        String fullPath = ((Object)Paths.get(stageMetricsFileName, new String[0])).toString();
        try (FileInputStream is = new FileInputStream(fullPath);){
            list = (List)((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this.objectMapper()).readValue((InputStream)is, ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(StageVals.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        }
        return list;
    }

    public List<TaskVals> readSerializedTaskMetricsJSON(String taskMetricsFileName) {
        List list;
        String fullPath = ((Object)Paths.get(taskMetricsFileName, new String[0])).toString();
        try (FileInputStream is = new FileInputStream(fullPath);){
            list = (List)((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this.objectMapper()).readValue((InputStream)is, ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(TaskVals.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        }
        return list;
    }

    public static final /* synthetic */ boolean $anonfun$writeSerializedJSONToHadoop$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$writeSerializedJSONToHadoop$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("spark.hadoop.");
        return bl;
    }

    public static final /* synthetic */ void $anonfun$writeSerializedJSONToHadoop$3(Configuration hadoopConf$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        hadoopConf$1.set(key.substring("spark.hadoop.".length()), value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private IOUtils$() {
        MODULE$ = this;
        this.objectMapper = new ScalaObjectMapper(){
            private final Class<Map<?, ?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$MAP;
            private final Class<Option<?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$OPTION;
            private final Class<Iterable<?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$ITERABLE;

            public final <Target, MixinSource> ObjectMapper addMixin(Manifest<Target> evidence$1, Manifest<MixinSource> evidence$2) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.addMixin$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$1, evidence$2);
            }

            public final <Target, MixinSource> ObjectMapper addMixInAnnotations(Manifest<Target> evidence$3, Manifest<MixinSource> evidence$4) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.addMixInAnnotations$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$3, evidence$4);
            }

            public final <T> Class<?> findMixInClassFor(Manifest<T> evidence$5) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.findMixInClassFor$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$5);
            }

            public <T> JavaType constructType(Manifest<T> m) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.constructType$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, m);
            }

            public <T> T readValue(JsonParser jp, Manifest<T> evidence$6) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.readValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (JsonParser)jp, evidence$6);
            }

            public <T> MappingIterator<T> readValues(JsonParser jp, Manifest<T> evidence$7) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.readValues$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (JsonParser)jp, evidence$7);
            }

            public <T> T treeToValue(TreeNode n, Manifest<T> evidence$8) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.treeToValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (TreeNode)n, evidence$8);
            }

            public <T> boolean canSerialize(Manifest<T> evidence$9) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.canSerialize$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$9);
            }

            public <T> boolean canDeserialize(Manifest<T> evidence$10) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.canDeserialize$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$10);
            }

            public <T> T readValue(File src, Manifest<T> evidence$11) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.readValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (File)src, evidence$11);
            }

            public <T> T readValue(URL src, Manifest<T> evidence$12) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.readValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (URL)src, evidence$12);
            }

            public <T> T readValue(String content, Manifest<T> evidence$13) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.readValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (String)content, evidence$13);
            }

            public <T> T readValue(Reader src, Manifest<T> evidence$14) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.readValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (Reader)src, evidence$14);
            }

            public <T> T readValue(InputStream src, Manifest<T> evidence$15) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.readValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (InputStream)src, evidence$15);
            }

            public <T> T readValue(byte[] src, Manifest<T> evidence$16) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.readValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (byte[])src, evidence$16);
            }

            public <T> T readValue(byte[] src, int offset, int len, Manifest<T> evidence$17) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.readValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (byte[])src, (int)offset, (int)len, evidence$17);
            }

            public <T> T updateValue(T valueToUpdate, File src, Manifest<T> evidence$18) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.updateValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, valueToUpdate, (File)src, evidence$18);
            }

            public <T> T updateValue(T valueToUpdate, URL src, Manifest<T> evidence$19) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.updateValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, valueToUpdate, (URL)src, evidence$19);
            }

            public <T> T updateValue(T valueToUpdate, String content, Manifest<T> evidence$20) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.updateValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, valueToUpdate, (String)content, evidence$20);
            }

            public <T> T updateValue(T valueToUpdate, Reader src, Manifest<T> evidence$21) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.updateValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, valueToUpdate, (Reader)src, evidence$21);
            }

            public <T> T updateValue(T valueToUpdate, InputStream src, Manifest<T> evidence$22) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.updateValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, valueToUpdate, (InputStream)src, evidence$22);
            }

            public <T> T updateValue(T valueToUpdate, byte[] src, Manifest<T> evidence$23) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.updateValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, valueToUpdate, (byte[])src, evidence$23);
            }

            public <T> T updateValue(T valueToUpdate, byte[] src, int offset, int len, Manifest<T> evidence$24) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.updateValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, valueToUpdate, (byte[])src, (int)offset, (int)len, evidence$24);
            }

            public <T> ObjectWriter writerWithView(Manifest<T> evidence$26) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.writerWithView$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$26);
            }

            public <T> ObjectWriter writerWithType(Manifest<T> evidence$27) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.writerWithType$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$27);
            }

            public <T> ObjectWriter writerFor(Manifest<T> evidence$28) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.writerFor$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$28);
            }

            public <T> ObjectReader reader(Manifest<T> evidence$29) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.reader$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$29);
            }

            public <T> ObjectReader readerFor(Manifest<T> evidence$30) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.readerFor$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$30);
            }

            public <T> ObjectReader readerWithView(Manifest<T> evidence$31) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.readerWithView$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$31);
            }

            public <T> T convertValue(Object fromValue, Manifest<T> evidence$32) {
                return (T)com.fasterxml.jackson.module.scala.ScalaObjectMapper.convertValue$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (Object)fromValue, evidence$32);
            }

            public <T> JsonSchema generateJsonSchema(Manifest<T> evidence$33) {
                return com.fasterxml.jackson.module.scala.ScalaObjectMapper.generateJsonSchema$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, evidence$33);
            }

            public <T> void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, Manifest<T> evidence$34) {
                com.fasterxml.jackson.module.scala.ScalaObjectMapper.acceptJsonFormatVisitor$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this, (JsonFormatVisitorWrapper)visitor, evidence$34);
            }

            public Class<Map<?, ?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$MAP() {
                return this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$MAP;
            }

            public Class<Option<?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$OPTION() {
                return this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$OPTION;
            }

            public Class<Iterable<?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$ITERABLE() {
                return this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$ITERABLE;
            }

            public final void com$fasterxml$jackson$module$scala$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$ScalaObjectMapper$$MAP_$eq(Class<Map<?, ?>> x$1) {
                this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$MAP = x$1;
            }

            public final void com$fasterxml$jackson$module$scala$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$ScalaObjectMapper$$OPTION_$eq(Class<Option<?>> x$1) {
                this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$OPTION = x$1;
            }

            public final void com$fasterxml$jackson$module$scala$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$ScalaObjectMapper$$ITERABLE_$eq(Class<Iterable<?>> x$1) {
                this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$ITERABLE = x$1;
            }
            {
                com.fasterxml.jackson.module.scala.ScalaObjectMapper.$init$((com.fasterxml.jackson.module.scala.ScalaObjectMapper)this);
            }
        };
        this.objectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.objectWriter = this.objectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
    }
}

