/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jmx.JmxReporter;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class DropwizardMetrics$ {
    public static DropwizardMetrics$ MODULE$;
    private final MetricRegistry registry;
    private final Logger logger;
    private final Set<String> knownGauges;
    private final Set<String> knownCounters;
    private final Set<String> knownTimers;
    private final JmxReporter reporter;
    private final TrieMap<String, Object> ch$cern$metrics$DropwizardMetrics$$gauges;
    private final TrieMap<String, Counter> counters;
    private final TrieMap<String, Timer> timers;

    static {
        new DropwizardMetrics$();
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    private Logger logger() {
        return this.logger;
    }

    private String getNamespace() {
        String path = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
        File file = new File(path);
        if (file.exists() && file.canRead()) {
            return Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString().trim();
        }
        return "unknown";
    }

    private String getPodName() {
        return (String)package$.MODULE$.env().getOrElse((Object)"HOSTNAME", (Function0 & Serializable & scala.Serializable)() -> "unknown");
    }

    private Set<String> knownGauges() {
        return this.knownGauges;
    }

    private Set<String> knownCounters() {
        return this.knownCounters;
    }

    private Set<String> knownTimers() {
        return this.knownTimers;
    }

    private JmxReporter reporter() {
        return this.reporter;
    }

    public void setMetricAutoType(String shortname, double value) {
        String lower = shortname.toLowerCase();
        String metricType = lower.contains("time") || lower.contains("duration") ? "timer" : (lower.contains("peak") || lower.contains("size") ? "gauge" : "counter");
        this.setMetric(shortname, value, metricType);
    }

    public void setMetric(String shortname, double value, String metricType) {
        String kind = metricType.toLowerCase();
        String name = new StringBuilder(2).append(this.getNamespace()).append(".").append(this.getPodName()).append(".").append(shortname).toString();
        this.logger().debug(new StringBuilder(19).append("[JMX] Setting ").append(kind).append(": ").append(shortname).append(" = ").append(value).toString());
        String string = kind;
        if ("counter".equals(string)) {
            Object object;
            if (!this.knownCounters().contains((Object)name)) {
                this.counters().update((Object)name, (Object)this.registry().counter(name));
                object = BoxesRunTime.boxToBoolean((boolean)this.knownCounters().add((Object)name));
            } else {
                object = BoxedUnit.UNIT;
            }
            long current = ((Counter)this.counters().apply((Object)name)).getCount();
            long delta = (long)value - current;
            if (delta > 0L) {
                ((Counter)this.counters().apply((Object)name)).inc(delta);
                return;
            }
            return;
        }
        if ("gauge".equals(string)) {
            Object object;
            if (!this.knownGauges().contains((Object)name)) {
                this.registry().register(name, (Metric)new Gauge<Object>(name){
                    private final String name$1;

                    public double getValue() {
                        return BoxesRunTime.unboxToDouble((Object)DropwizardMetrics$.MODULE$.ch$cern$metrics$DropwizardMetrics$$gauges().getOrElse((Object)this.name$1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                    }
                    {
                        this.name$1 = name$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getValue$1()}, serializedLambda);
                    }
                });
                object = BoxesRunTime.boxToBoolean((boolean)this.knownGauges().add((Object)name));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.ch$cern$metrics$DropwizardMetrics$$gauges().update((Object)name, (Object)BoxesRunTime.boxToDouble((double)value));
            return;
        }
        if ("timer".equals(string)) {
            Object object;
            if (!this.knownTimers().contains((Object)name)) {
                this.timers().update((Object)name, (Object)this.registry().timer(name));
                object = BoxesRunTime.boxToBoolean((boolean)this.knownTimers().add((Object)name));
            } else {
                object = BoxedUnit.UNIT;
            }
            ((Timer)this.timers().apply((Object)name)).update((long)value, TimeUnit.MILLISECONDS);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(21).append("Unknown metric type: ").append(metricType).toString());
    }

    public String describeMetrics() {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        sb.append(new StringBuilder(36).append("Metrics for namespace '").append(this.getNamespace()).append("' and pod '").append(this.getPodName()).append("'\n").toString());
        sb.append(new StringBuilder(15).append("Total gauges: ").append(this.ch$cern$metrics$DropwizardMetrics$$gauges().size()).append("\n").toString());
        this.ch$cern$metrics$DropwizardMetrics$$gauges().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                double value = tuple2._2$mcD$sp();
                return sb.append(new StringBuilder(11).append("Gauge: ").append(name).append(" = ").append(value).append("\n").toString());
            }
            throw new MatchError((Object)tuple2);
        });
        sb.append(new StringBuilder(17).append("Total counters: ").append(this.counters().size()).append("\n").toString());
        this.counters().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Counter counter = (Counter)tuple2._2();
                return sb.append(new StringBuilder(13).append("Counter: ").append(name).append(" = ").append(counter.getCount()).append("\n").toString());
            }
            throw new MatchError((Object)tuple2);
        });
        sb.append(new StringBuilder(15).append("Total timers: ").append(this.timers().size()).append("\n").toString());
        this.timers().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Timer timer = (Timer)tuple2._2();
                Snapshot snapshot = timer.getSnapshot();
                return sb.append(new StringBuilder(17).append("Timer: ").append(name).append(" = ").append("count=").append(timer.getCount()).append("\n").toString());
            }
            throw new MatchError((Object)tuple2);
        });
        return sb.toString();
    }

    public TrieMap<String, Object> ch$cern$metrics$DropwizardMetrics$$gauges() {
        return this.ch$cern$metrics$DropwizardMetrics$$gauges;
    }

    private TrieMap<String, Counter> counters() {
        return this.counters;
    }

    private TrieMap<String, Timer> timers() {
        return this.timers;
    }

    private DropwizardMetrics$() {
        MODULE$ = this;
        this.registry = new MetricRegistry();
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.knownGauges = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.knownCounters = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.knownTimers = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reporter = JmxReporter.forRegistry((MetricRegistry)this.registry()).inDomain("sparkmeasure.metrics").build();
        this.reporter().start();
        this.ch$cern$metrics$DropwizardMetrics$$gauges = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.counters = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.timers = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

