/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.PushgatewayConfig;
import org.apache.spark.SparkConf;
import org.apache.spark.scheduler.TaskLocality$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    public String formatDuration(long milliseconds) {
        if (milliseconds < 100L) {
            return new StringOps(Predef$.MODULE$.augmentString("%d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)milliseconds)}));
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < 1.0) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        if (seconds < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)10) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        if (minutes < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        double hours = minutes / (double)60;
        return new StringOps(Predef$.MODULE$.augmentString("%.1f h")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)hours)}));
    }

    public String formatBytes(long bytes) {
        String unit;
        Tuple2 tuple2;
        long trillion = 0x10000000000L;
        long billion = 0x40000000L;
        long million = 0x100000L;
        long thousand = 1024L;
        double bytesDouble = bytes;
        Tuple2 tuple22 = bytesDouble >= (double)(2L * trillion) ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytesDouble / (double)trillion)), (Object)" TB") : (bytes >= 2L * billion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytesDouble / (double)billion)), (Object)" GB") : (bytes >= 2L * million ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytesDouble / (double)million)), (Object)" MB") : (tuple2 = bytes >= 2L * thousand ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytesDouble / (double)thousand)), (Object)" KB") : new Tuple2((Object)BoxesRunTime.boxToDouble((double)bytesDouble), (Object)" Bytes"))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double value = tuple2._1$mcD$sp();
        String unit2 = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)value), (Object)unit2);
        double value2 = tuple23._1$mcD$sp();
        String string = unit = (String)tuple23._2();
        String string2 = " Bytes";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return new StringOps(Predef$.MODULE$.augmentString("%d%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((int)value2)), unit}));
        }
        return new StringOps(Predef$.MODULE$.augmentString("%.1f%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)value2), unit}));
    }

    public LinkedHashMap<String, Object> zeroMetricsStage() {
        LinkedHashMap zeroedMetrics = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numStages"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTasks"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"elapsedTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stageDuration"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorRunTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorCpuTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorDeserializeTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorDeserializeCpuTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resultSerializationTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jvmGCTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleFetchWaitTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleWriteTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resultSize"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"diskBytesSpilled"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"memoryBytesSpilled"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"peakExecutionMemory"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recordsRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bytesRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recordsWritten"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bytesWritten"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleRecordsRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleTotalBlocksFetched"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleLocalBlocksFetched"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleRemoteBlocksFetched"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleTotalBytesRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleLocalBytesRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleRemoteBytesRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleRemoteBytesReadToDisk"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleBytesWritten"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleRecordsWritten"), (Object)BoxesRunTime.boxToLong((long)0L))}));
        return zeroedMetrics;
    }

    public LinkedHashMap<String, Object> zeroMetricsTask() {
        LinkedHashMap zeroedMetrics = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTasks"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"successful tasks"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"speculative tasks"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskDuration"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schedulerDelayTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorRunTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorCpuTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorDeserializeTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorDeserializeCpuTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resultSerializationTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jvmGCTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleFetchWaitTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleWriteTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gettingResultTime"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resultSize"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"diskBytesSpilled"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"memoryBytesSpilled"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"peakExecutionMemory"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recordsRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bytesRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recordsWritten"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bytesWritten"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleRecordsRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleTotalBlocksFetched"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleLocalBlocksFetched"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleRemoteBlocksFetched"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleTotalBytesRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleLocalBytesRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleRemoteBytesRead"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleRemoteBytesReadToDisk"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleBytesWritten"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shuffleRecordsWritten"), (Object)BoxesRunTime.boxToLong((long)0L))}));
        return zeroedMetrics;
    }

    public String prettyPrintValues(String metric, long value) {
        String name = metric.toLowerCase();
        String basicValue = Long.toString(value);
        String optionalValueWithUnits = name.contains("time") || name.contains("duration") ? new StringBuilder(3).append(" (").append(this.formatDuration(value)).append(")").toString() : (name.contains("bytes") || name.contains("size") ? new StringBuilder(3).append(" (").append(this.formatBytes(value)).append(")").toString() : "");
        return new StringBuilder(4).append(metric).append(" => ").append(basicValue).append(optionalValueWithUnits).toString();
    }

    public int encodeTaskLocality(Enumeration.Value taskLocality) {
        Enumeration.Value value = taskLocality;
        Enumeration.Value value2 = TaskLocality$.MODULE$.PROCESS_LOCAL();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return 0;
        }
        Enumeration.Value value4 = TaskLocality$.MODULE$.NODE_LOCAL();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return 1;
        }
        Enumeration.Value value6 = TaskLocality$.MODULE$.RACK_LOCAL();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return 2;
        }
        Enumeration.Value value8 = TaskLocality$.MODULE$.NO_PREF();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return 3;
        }
        Enumeration.Value value10 = TaskLocality$.MODULE$.ANY();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return 4;
        }
        return -1;
    }

    public String parseMetricsFormat(SparkConf conf, Logger logger, String defaultFormat) {
        String metricsFormat = conf.get("spark.sparkmeasure.outputFormat", defaultFormat);
        String string = metricsFormat;
        if ("json".equals(string) ? true : ("java".equals(string) ? true : "json_to_hadoop".equals(string))) {
            logger.info(new StringBuilder(31).append("Using ").append(metricsFormat).append(" as serialization format.").toString());
        } else {
            logger.warn(new StringBuilder(107).append("Invalid serialization format: ").append(metricsFormat).append(".").append(" Configure with: spark.sparkmeasure.outputFormat=json|javaser|json_to_hadoop").toString());
        }
        return metricsFormat;
    }

    public boolean parsePrintToStdout(SparkConf conf, Logger logger, boolean defaultVal) {
        boolean printToStdout;
        block0: {
            printToStdout = conf.getBoolean("spark.sparkmeasure.printToStdout", defaultVal);
            if (!printToStdout) break block0;
            logger.info("Will print metrics output to stdout in JSON format");
        }
        return printToStdout;
    }

    public String parseMetricsFilename(SparkConf conf, Logger logger, String defaultFileName) {
        String metricsFileName = conf.get("spark.sparkmeasure.outputFilename", defaultFileName);
        if (metricsFileName.isEmpty()) {
            logger.warn("No output file will be written. If you want to write the output to a file, configure with spark.sparkmeasure.outputFilename=<output file>");
        } else {
            logger.info(new StringBuilder(18).append("Writing output to ").append(metricsFileName).toString());
        }
        return metricsFileName;
    }

    public String parseInfluxDBURL(SparkConf conf, Logger logger) {
        String influxdbURL = conf.get("spark.sparkmeasure.influxdbURL", "http://localhost:8086");
        if (influxdbURL.isEmpty()) {
            logger.error("InfluxDB URL not found, this will make the listener fail.");
            throw new RuntimeException();
        }
        logger.info(new StringBuilder(24).append("Found URL for InfluxDB: ").append(influxdbURL).toString());
        return influxdbURL;
    }

    public Tuple2<String, String> parseInfluxDBCredentials(SparkConf conf, Logger logger) {
        String influxdbUsername = conf.get("spark.sparkmeasure.influxdbUsername", "");
        String influxdbPassword = conf.get("spark.sparkmeasure.influxdbPassword", "");
        if (influxdbUsername.isEmpty() && influxdbPassword.isEmpty()) {
            logger.warn("Credentials for InfluxDB connection not found, using empty username and password, InfluxDB must be running with auth-enabled=false");
        } else {
            logger.info("Credentials for InfluxDB connection found");
        }
        return new Tuple2((Object)influxdbUsername, (Object)influxdbPassword);
    }

    public String parseInfluxDBName(SparkConf conf, Logger logger) {
        String influxdbName = conf.get("spark.sparkmeasure.influxdbName", "sparkmeasure");
        logger.info(new StringBuilder(15).append("InfluxDB name: ").append(influxdbName).toString());
        return influxdbName;
    }

    public boolean parseInfluxDBStagemetrics(SparkConf conf, Logger logger) {
        boolean influxdbStagemetrics = conf.getBoolean("spark.sparkmeasure.influxdbStagemetrics", false);
        logger.info(new StringBuilder(23).append("Log also stagemetrics: ").append(Boolean.toString(influxdbStagemetrics)).toString());
        return influxdbStagemetrics;
    }

    public Tuple3<String, String, Map<String, String>> parseKafkaConfig(SparkConf conf, Logger logger) {
        String broker = conf.get("spark.sparkmeasure.kafkaBroker", "");
        String topic = conf.get("spark.sparkmeasure.kafkaTopic", "");
        if (broker.isEmpty() || topic.isEmpty()) {
            throw new IllegalArgumentException("broker & topic are required for the Kafka connection");
        }
        logger.info(new StringBuilder(14).append("Kafka broker: ").append(broker).toString());
        logger.info(new StringBuilder(13).append("Kafka topic: ").append(topic).toString());
        String prefix = "spark.sparkmeasure.kafka.";
        Map kafkaParams = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).collect((PartialFunction)new Serializable(prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String k = (String)A1._1();
                    String v = (String)A1._2();
                    if (k.startsWith(this.prefix$1)) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString(k)).stripPrefix(this.prefix$1)), (Object)v);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                String k;
                Tuple2<String, String> tuple2 = x1;
                return tuple2 != null && (k = (String)tuple2._1()).startsWith(this.prefix$1);
            }
            {
                this.prefix$1 = prefix$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return new Tuple3((Object)broker, (Object)topic, (Object)kafkaParams);
    }

    public PushgatewayConfig parsePushGatewayConfig(SparkConf conf, Logger logger) {
        String URL2 = conf.get("spark.sparkmeasure.pushgateway", "");
        if (URL2.isEmpty()) {
            throw new IllegalArgumentException("SERVER:PORT configuration for the Prometheus Push Gateway is required, use --conf spark.sparkmeasure.pushgateway=SERVER:PORT");
        }
        logger.info(new StringBuilder(41).append("Prometheus Push Gateway server and port: ").append(URL2).toString());
        return new PushgatewayConfig(URL2, conf.get("spark.sparkmeasure.pushgateway.jobname", "pushgateway"), Integer.parseInt(conf.get("spark.sparkmeasure.pushgateway.http.connection.timeout", "5000")), Integer.parseInt(conf.get("spark.sparkmeasure.pushgateway.http.read.timeout", "5000")));
    }

    public String[] parseExecutorMetricsConfig(SparkConf conf, Logger logger) {
        String metrics = conf.get("spark.sparkmeasure.stageinfo.executormetrics", "JVMHeapMemory,OnHeapExecutionMemory");
        logger.info(new StringBuilder(34).append("Executor metrics being collected: ").append(metrics.toString()).toString());
        return metrics.split(",", -1);
    }

    public boolean parseExtraStageMetrics(SparkConf conf, Logger logger) {
        boolean extraStageMetrics = conf.getBoolean("spark.sparkmeasure.stageinfo.verbose", true);
        logger.info(new StringBuilder(40).append("Collect and report extra stage metrics: ").append(Boolean.toString(extraStageMetrics)).toString());
        return extraStageMetrics;
    }

    private Utils$() {
        MODULE$ = this;
    }
}

