/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.InfluxDBSink;
import ch.cern.sparkmeasure.Utils$;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.TaskInfo;
import org.influxdb.dto.Point;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a2A!\u0002\u0004\u0001\u001b!A!\u0003\u0001B\u0001B\u0003%1\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003\"\u0001\u0011\u0005#\u0005C\u00032\u0001\u0011\u0005#G\u0001\u000bJ]\u001adW\u000f\u001f#C'&t7.\u0012=uK:$W\r\u001a\u0006\u0003\u000f!\tAb\u001d9be.lW-Y:ve\u0016T!!\u0003\u0006\u0002\t\r,'O\u001c\u0006\u0002\u0017\u0005\u00111\r[\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ta\u0011J\u001c4mkb$%iU5oW\u0006!1m\u001c8g!\t!2$D\u0001\u0016\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<\u0017B\u0001\u000f\u0016\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0003?\u0001\u0002\"a\u0004\u0001\t\u000bI\u0011\u0001\u0019A\n\u0002\u0017=tG+Y:l'R\f'\u000f\u001e\u000b\u0003G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012A!\u00168ji\")!f\u0001a\u0001W\u0005IA/Y:l'R\f'\u000f\u001e\t\u0003Y=j\u0011!\f\u0006\u0003]U\t\u0011b]2iK\u0012,H.\u001a:\n\u0005Aj#AF*qCJ\\G*[:uK:,'\u000fV1tWN#\u0018M\u001d;\u0002\u0013=tG+Y:l\u000b:$GCA\u00124\u0011\u0015!D\u00011\u00016\u0003\u001d!\u0018m]6F]\u0012\u0004\"\u0001\f\u001c\n\u0005]j#\u0001F*qCJ\\G*[:uK:,'\u000fV1tW\u0016sG\r")
public class InfluxDBSinkExtended
extends InfluxDBSink {
    public void onTaskStart(SparkListenerTaskStart taskStart) {
        TaskInfo taskInfo = taskStart.taskInfo();
        Point point = Point.measurement((String)"tasks_started").tag("applicationId", this.appId()).time(taskInfo.launchTime(), TimeUnit.MICROSECONDS).addField("taskId", taskInfo.taskId()).addField("attemptNumber", (long)taskInfo.attemptNumber()).addField("stageId", (long)taskStart.stageId()).build();
        this.database().write(point);
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        TaskInfo taskInfo = taskEnd.taskInfo();
        TaskMetrics taskmetrics = taskEnd.taskMetrics();
        Point point1 = Point.measurement((String)"tasks_ended").tag("applicationId", this.appId()).time(taskInfo.finishTime(), TimeUnit.MILLISECONDS).addField("taskId", taskInfo.taskId()).addField("attemptNumber", (long)taskInfo.attemptNumber()).addField("launchTime", taskInfo.launchTime()).addField("stageId", (long)taskEnd.stageId()).build();
        this.database().write(point1);
        Point point2 = Point.measurement((String)"task_metrics").tag("applicationId", this.appId()).time(taskInfo.finishTime(), TimeUnit.MILLISECONDS).addField("taskId", taskInfo.taskId()).addField("attemptNumber", (long)taskInfo.attemptNumber()).addField("stageId", (long)taskEnd.stageId()).addField("launchTime", taskInfo.launchTime()).addField("completionTime", taskInfo.finishTime()).addField("failed", taskInfo.failed()).addField("speculative", taskInfo.speculative()).addField("killed", taskInfo.killed()).addField("finished", taskInfo.finished()).addField("executorId", taskInfo.executorId()).addField("duration", taskInfo.duration()).addField("successful", taskInfo.successful()).addField("host", taskInfo.host()).addField("taskLocality", (long)Utils$.MODULE$.encodeTaskLocality(taskInfo.taskLocality())).addField("executorRunTime", taskmetrics.executorRunTime()).addField("executorCpuTime", taskmetrics.executorCpuTime()).addField("executorDeserializeCpuTime", taskmetrics.executorDeserializeCpuTime()).addField("executorDeserializeTime", taskmetrics.executorDeserializeTime()).addField("jvmGCTime", taskmetrics.jvmGCTime()).addField("memoryBytesSpilled", taskmetrics.memoryBytesSpilled()).addField("peakExecutionMemory", taskmetrics.peakExecutionMemory()).addField("resultSerializationTime", taskmetrics.resultSerializationTime()).addField("resultSize", taskmetrics.resultSize()).addField("bytesRead", taskmetrics.inputMetrics().bytesRead()).addField("recordsRead", taskmetrics.inputMetrics().recordsRead()).addField("bytesWritten", taskmetrics.outputMetrics().bytesWritten()).addField("recordsWritten", taskmetrics.outputMetrics().recordsWritten()).addField("shuffleTotalBytesRead", taskmetrics.shuffleReadMetrics().totalBytesRead()).addField("shuffleRemoteBytesRead", taskmetrics.shuffleReadMetrics().remoteBytesRead()).addField("shuffleLocalBytesRead", taskmetrics.shuffleReadMetrics().localBytesRead()).addField("shuffleTotalBlocksFetched", taskmetrics.shuffleReadMetrics().totalBlocksFetched()).addField("shuffleLocalBlocksFetched", taskmetrics.shuffleReadMetrics().localBlocksFetched()).addField("shuffleRemoteBlocksFetched", taskmetrics.shuffleReadMetrics().remoteBlocksFetched()).addField("shuffleRecordsRead", taskmetrics.shuffleReadMetrics().recordsRead()).addField("shuffleFetchWaitTime", taskmetrics.shuffleReadMetrics().fetchWaitTime()).addField("shuffleBytesWritten", taskmetrics.shuffleWriteMetrics().bytesWritten()).addField("shuffleRecordsWritten", taskmetrics.shuffleWriteMetrics().recordsWritten()).addField("shuffleWriteTime", taskmetrics.shuffleWriteMetrics().writeTime()).build();
        this.database().write(point2);
    }

    public InfluxDBSinkExtended(SparkConf conf) {
        super(conf);
    }
}

