/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.Utils$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.cluster.ExecutorInfo;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001\u0002\u0014(\u00019B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0006\u0001\u0002!\t!\u0011\u0005\t\u000b\u0002A)\u0019!C\u0001\r\"9Q\n\u0001b\u0001\n\u0003q\u0005B\u0002/\u0001A\u0003%q\n\u0003\u0006^\u0001A\u0005\t1!Q\u0001\nyCqA\u0019\u0001C\u0002\u0013\u0005a\n\u0003\u0004d\u0001\u0001\u0006Ia\u0014\u0005\bI\u0002\u0011\r\u0011\"\u0001O\u0011\u0019)\u0007\u0001)A\u0005\u001f\"9a\r\u0001b\u0001\n\u00039\u0007B\u00028\u0001A\u0003%\u0001\u000eC\u0004p\u0001\t\u0007I\u0011\u0001(\t\rA\u0004\u0001\u0015!\u0003P\u0011\u001d\t\bA1A\u0005\u0002\u001dDaA\u001d\u0001!\u0002\u0013A\u0007bB:\u0001\u0005\u0004%\t\u0001\u001e\u0005\u0007q\u0002\u0001\u000b\u0011B;\t\u000fe\u0004!\u0019!C\u0001i\"1!\u0010\u0001Q\u0001\nUDqa\u001f\u0001A\u0002\u0013\u0005A\u0010C\u0005\u0002\n\u0001\u0001\r\u0011\"\u0001\u0002\f!9\u0011Q\u0003\u0001!B\u0013i\b\u0002CA\f\u0001\u0001\u0007I\u0011\u0001?\t\u0013\u0005e\u0001\u00011A\u0005\u0002\u0005m\u0001bBA\u0010\u0001\u0001\u0006K! \u0005\t\u0003C\u0001\u0001\u0019!C\u0001\u001d\"I\u00111\u0005\u0001A\u0002\u0013\u0005\u0011Q\u0005\u0005\b\u0003S\u0001\u0001\u0015)\u0003P\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!!\u000f\u0001\t\u0003\nY\u0004C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u00111\r\u0001\u0005B\u0005\u0015\u0004bBA9\u0001\u0011\u0005\u00131\u000f\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\ti\t\u0001C!\u0003\u001f\u0013A\"\u00138gYVDHIQ*j].T!\u0001K\u0015\u0002\u0019M\u0004\u0018M]6nK\u0006\u001cXO]3\u000b\u0005)Z\u0013\u0001B2fe:T\u0011\u0001L\u0001\u0003G\"\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001'O\u0007\u0002c)\u0011!gM\u0001\ng\u000eDW\rZ;mKJT!\u0001N\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0005\u0003uE\u0012Qb\u00159be.d\u0015n\u001d;f]\u0016\u0014\u0018\u0001B2p]\u001a\u0004\"!\u0010 \u000e\u0003MJ!aP\u001a\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u0002C\tB\u00111\tA\u0007\u0002O!)1H\u0001a\u0001y\u00051An\\4hKJ,\u0012a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015^\nQa\u001d7gi)L!\u0001T%\u0003\r1{wmZ3s\u0003\r)(\u000f\\\u000b\u0002\u001fB\u0011\u0001+\u0017\b\u0003#^\u0003\"AU+\u000e\u0003MS!\u0001V\u0017\u0002\rq\u0012xn\u001c;?\u0015\u00051\u0016!B:dC2\f\u0017B\u0001-V\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a+\u0016\u0001B;sY\u0002\n1\u0001\u001f\u00132!\u0011y\u0006mT(\u000e\u0003UK!!Y+\u0003\rQ+\b\u000f\\33\u0003!)8/\u001a:oC6,\u0017!C;tKJt\u0017-\\3!\u0003!\u0001\u0018m]:x_J$\u0017!\u00039bgN<xN\u001d3!\u0003!IgN\u001a7vq\u0012\u0013U#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-<\u0014\u0001C5oM2,\b\u0010\u001a2\n\u00055T'\u0001C%oM2,\b\u0010\u0012\"\u0002\u0013%tg\r\\;y\t\n\u0003\u0013A\u00023c\u001d\u0006lW-A\u0004eE:\u000bW.\u001a\u0011\u0002\u0011\u0011\fG/\u00192bg\u0016\f\u0011\u0002Z1uC\n\f7/\u001a\u0011\u0002\u001f1|wm\u0015;bO\u0016lU\r\u001e:jGN,\u0012!\u001e\t\u0003?ZL!a^+\u0003\u000f\t{w\u000e\\3b]\u0006\u0001Bn\\4Ti\u0006<W-T3ue&\u001c7\u000fI\u0001\fK:\f'\r\\3CCR\u001c\u0007.\u0001\u0007f]\u0006\u0014G.\u001a\"bi\u000eD\u0007%A\u0003baBLE-F\u0001~!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L!AW@\u0002\u0013\u0005\u0004\b/\u00133`I\u0015\fH\u0003BA\u0007\u0003'\u00012aXA\b\u0013\r\t\t\"\u0016\u0002\u0005+:LG\u000fC\u0004^-\u0005\u0005\t\u0019A?\u0002\r\u0005\u0004\b/\u00133!\u0003\u001d\t\u0007\u000f\u001d(b[\u0016\f1\"\u00199q\u001d\u0006lWm\u0018\u0013fcR!\u0011QBA\u000f\u0011\u001di\u0016$!AA\u0002u\f\u0001\"\u00199q\u001d\u0006lW\rI\u0001\u0019Ift\u0017-\\5d\u00032dwnY1uS>tWI\\1cY\u0016$\u0017\u0001\b3z]\u0006l\u0017nY!mY>\u001c\u0017\r^5p]\u0016s\u0017M\u00197fI~#S-\u001d\u000b\u0005\u0003\u001b\t9\u0003C\u0004^9\u0005\u0005\t\u0019A(\u00023\u0011Lh.Y7jG\u0006cGn\\2bi&|g.\u00128bE2,G\rI\u0001\u0010_:,\u00050Z2vi>\u0014\u0018\t\u001a3fIR!\u0011QBA\u0018\u0011\u001d\t\tD\ba\u0001\u0003g\tQ\"\u001a=fGV$xN]!eI\u0016$\u0007c\u0001\u0019\u00026%\u0019\u0011qG\u0019\u00035M\u0003\u0018M]6MSN$XM\\3s\u000bb,7-\u001e;pe\u0006#G-\u001a3\u0002!=t7\u000b^1hKN+(-\\5ui\u0016$G\u0003BA\u0007\u0003{Aq!a\u0010 \u0001\u0004\t\t%\u0001\bti\u0006<WmU;c[&$H/\u001a3\u0011\u0007A\n\u0019%C\u0002\u0002FE\u00121d\u00159be.d\u0015n\u001d;f]\u0016\u00148\u000b^1hKN+(-\\5ui\u0016$\u0017\u0001E8o'R\fw-Z\"p[BdW\r^3e)\u0011\ti!a\u0013\t\u000f\u00055\u0003\u00051\u0001\u0002P\u0005q1\u000f^1hK\u000e{W\u000e\u001d7fi\u0016$\u0007c\u0001\u0019\u0002R%\u0019\u00111K\u0019\u00037M\u0003\u0018M]6MSN$XM\\3s'R\fw-Z\"p[BdW\r^3e\u00031ygn\u0014;iKJ,e/\u001a8u)\u0011\ti!!\u0017\t\u000f\u0005m\u0013\u00051\u0001\u0002^\u0005)QM^3oiB\u0019\u0001'a\u0018\n\u0007\u0005\u0005\u0014G\u0001\nTa\u0006\u00148\u000eT5ti\u0016tWM]#wK:$\u0018AC8o\u0015>\u00147\u000b^1siR!\u0011QBA4\u0011\u001d\tIG\ta\u0001\u0003W\n\u0001B[8c'R\f'\u000f\u001e\t\u0004a\u00055\u0014bAA8c\t)2\u000b]1sW2K7\u000f^3oKJTuNY*uCJ$\u0018\u0001C8o\u0015>\u0014WI\u001c3\u0015\t\u00055\u0011Q\u000f\u0005\b\u0003o\u001a\u0003\u0019AA=\u0003\u0019QwNY#oIB\u0019\u0001'a\u001f\n\u0007\u0005u\u0014GA\nTa\u0006\u00148\u000eT5ti\u0016tWM\u001d&pE\u0016sG-\u0001\np]\u0006\u0003\b\u000f\\5dCRLwN\\*uCJ$H\u0003BA\u0007\u0003\u0007Cq!!\"%\u0001\u0004\t9)\u0001\tbaBd\u0017nY1uS>t7\u000b^1siB\u0019\u0001'!#\n\u0007\u0005-\u0015GA\u000fTa\u0006\u00148\u000eT5ti\u0016tWM]!qa2L7-\u0019;j_:\u001cF/\u0019:u\u0003Ayg.\u00119qY&\u001c\u0017\r^5p]\u0016sG\r\u0006\u0003\u0002\u000e\u0005E\u0005bBAJK\u0001\u0007\u0011QS\u0001\u000fCB\u0004H.[2bi&|g.\u00128e!\r\u0001\u0014qS\u0005\u0004\u00033\u000b$aG*qCJ\\G*[:uK:,'/\u00119qY&\u001c\u0017\r^5p]\u0016sG\r")
public class InfluxDBSink
extends SparkListener {
    private Logger logger;
    private final SparkConf conf;
    private final String url;
    private final /* synthetic */ Tuple2 x$1;
    private final String username;
    private final String password;
    private final InfluxDB influxDB;
    private final String dbName;
    private final InfluxDB database;
    private final boolean logStageMetrics;
    private final boolean enableBatch;
    private String appId;
    private String appName;
    private String dynamicAllocationEnabled;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        InfluxDBSink influxDBSink = this;
        synchronized (influxDBSink) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String url() {
        return this.url;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public InfluxDB influxDB() {
        return this.influxDB;
    }

    public String dbName() {
        return this.dbName;
    }

    public InfluxDB database() {
        return this.database;
    }

    public boolean logStageMetrics() {
        return this.logStageMetrics;
    }

    public boolean enableBatch() {
        return this.enableBatch;
    }

    public String appId() {
        return this.appId;
    }

    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    public String appName() {
        return this.appName;
    }

    public void appName_$eq(String x$1) {
        this.appName = x$1;
    }

    public String dynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    public void dynamicAllocationEnabled_$eq(String x$1) {
        this.dynamicAllocationEnabled = x$1;
    }

    public void onExecutorAdded(SparkListenerExecutorAdded executorAdded) {
        String executorId = executorAdded.executorId();
        ExecutorInfo executorInfo = executorAdded.executorInfo();
        long startTime = executorAdded.time();
        Point point = Point.measurement((String)"executors_started").tag("applicationId", this.appId()).tag("spark.app.name", this.appName()).tag("spark.dynamicAllocation.enabled", this.dynamicAllocationEnabled()).addField("executorId", executorId).addField("executorHost", executorInfo.executorHost()).addField("totalCores", executorInfo.totalCores()).time(startTime, TimeUnit.MILLISECONDS).build();
        this.database().write(point);
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        long submissionTime = BoxesRunTime.unboxToLong((Object)stageSubmitted.stageInfo().submissionTime().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        int attemptNumber = stageSubmitted.stageInfo().attemptNumber();
        int stageId = stageSubmitted.stageInfo().stageId();
        Point point = Point.measurement((String)"stages_started").tag("applicationId", this.appId()).tag("spark.app.name", this.appName()).tag("spark.dynamicAllocation.enabled", this.dynamicAllocationEnabled()).addField("stageId", stageId).addField("attemptNUmber", attemptNumber).time(submissionTime, TimeUnit.MILLISECONDS).build();
        this.database().write(point);
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        int stageId = stageCompleted.stageInfo().stageId();
        long submissionTime = BoxesRunTime.unboxToLong((Object)stageCompleted.stageInfo().submissionTime().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        long completionTime = BoxesRunTime.unboxToLong((Object)stageCompleted.stageInfo().completionTime().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        int attemptNumber = stageCompleted.stageInfo().attemptNumber();
        Point point1 = Point.measurement((String)"stages_ended").tag("applicationId", this.appId()).tag("spark.app.name", this.appName()).tag("spark.dynamicAllocation.enabled", this.dynamicAllocationEnabled()).time(completionTime, TimeUnit.MILLISECONDS).addField("stageId", stageId).addField("attemptNumber", attemptNumber).addField("submissionTime", submissionTime).build();
        this.database().write(point1);
        if (this.logStageMetrics()) {
            TaskMetrics taskmetrics = stageCompleted.stageInfo().taskMetrics();
            Point point2 = Point.measurement((String)"stage_metrics").tag("applicationId", this.appId()).tag("spark.app.name", this.appName()).tag("spark.dynamicAllocation.enabled", this.dynamicAllocationEnabled()).time(completionTime, TimeUnit.MILLISECONDS).addField("stageId", stageId).addField("attemptNumber", attemptNumber).addField("failureReason", (String)stageCompleted.stageInfo().failureReason().getOrElse((Function0 & Serializable)() -> "")).addField("submissionTime", submissionTime).addField("completionTime", completionTime).addField("executorRunTime", taskmetrics.executorRunTime()).addField("executorCpuTime", taskmetrics.executorCpuTime()).addField("executorDeserializeCpuTime", taskmetrics.executorDeserializeCpuTime()).addField("executorDeserializeTime", taskmetrics.executorDeserializeTime()).addField("jvmGCTime", taskmetrics.jvmGCTime()).addField("memoryBytesSpilled", taskmetrics.memoryBytesSpilled()).addField("peakExecutionMemory", taskmetrics.peakExecutionMemory()).addField("resultSerializationTime", taskmetrics.resultSerializationTime()).addField("resultSize", taskmetrics.resultSize()).addField("bytesRead", taskmetrics.inputMetrics().bytesRead()).addField("recordsRead", taskmetrics.inputMetrics().recordsRead()).addField("bytesWritten", taskmetrics.outputMetrics().bytesWritten()).addField("recordsWritten", taskmetrics.outputMetrics().recordsWritten()).addField("shuffleTotalBytesRead", taskmetrics.shuffleReadMetrics().totalBytesRead()).addField("shuffleRemoteBytesRead", taskmetrics.shuffleReadMetrics().remoteBytesRead()).addField("shuffleRemoteBytesReadToDisk", taskmetrics.shuffleReadMetrics().remoteBytesReadToDisk()).addField("shuffleLocalBytesRead", taskmetrics.shuffleReadMetrics().localBytesRead()).addField("shuffleTotalBlocksFetched", taskmetrics.shuffleReadMetrics().totalBlocksFetched()).addField("shuffleLocalBlocksFetched", taskmetrics.shuffleReadMetrics().localBlocksFetched()).addField("shuffleRemoteBlocksFetched", taskmetrics.shuffleReadMetrics().remoteBlocksFetched()).addField("shuffleRecordsRead", taskmetrics.shuffleReadMetrics().recordsRead()).addField("shuffleFetchWaitTime", taskmetrics.shuffleReadMetrics().fetchWaitTime()).addField("shuffleBytesWritten", taskmetrics.shuffleWriteMetrics().bytesWritten()).addField("shuffleRecordsWritten", taskmetrics.shuffleWriteMetrics().recordsWritten()).addField("shuffleWriteTime", taskmetrics.shuffleWriteMetrics().writeTime()).build();
            this.database().write(point2);
            return;
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
            long startTime = sparkListenerSQLExecutionStart.time();
            long queryId = sparkListenerSQLExecutionStart.executionId();
            String description = sparkListenerSQLExecutionStart.description();
            Point point = Point.measurement((String)"queries_started").tag("applicationId", this.appId()).tag("spark.app.name", this.appName()).tag("spark.dynamicAllocation.enabled", this.dynamicAllocationEnabled()).time(startTime, TimeUnit.MILLISECONDS).addField("description", description).addField("queryId", queryId).build();
            this.database().write(point);
            return;
        }
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionEnd) {
            SparkListenerSQLExecutionEnd sparkListenerSQLExecutionEnd = (SparkListenerSQLExecutionEnd)sparkListenerEvent;
            long endTime = sparkListenerSQLExecutionEnd.time();
            long queryId = sparkListenerSQLExecutionEnd.executionId();
            Point point = Point.measurement((String)"queries_ended").tag("applicationId", this.appId()).tag("spark.app.name", this.appName()).tag("spark.dynamicAllocation.enabled", this.dynamicAllocationEnabled()).time(endTime, TimeUnit.MILLISECONDS).addField("queryId", queryId).build();
            this.database().write(point);
            return;
        }
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        long startTime = jobStart.time();
        int jobId = jobStart.jobId();
        Point point = Point.measurement((String)"jobs_started").tag("applicationId", this.appId()).tag("spark.app.name", this.appName()).tag("spark.dynamicAllocation.enabled", this.dynamicAllocationEnabled()).time(startTime, TimeUnit.MILLISECONDS).addField("jobID", jobId).build();
        this.database().write(point);
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        long completionTime = jobEnd.time();
        int jobId = jobEnd.jobId();
        Point point = Point.measurement((String)"jobs_ended").tag("applicationId", this.appId()).tag("spark.app.name", this.appName()).tag("spark.dynamicAllocation.enabled", this.dynamicAllocationEnabled()).time(completionTime, TimeUnit.MILLISECONDS).addField("jobID", jobId).build();
        this.database().write(point);
    }

    public void onApplicationStart(SparkListenerApplicationStart applicationStart) {
        this.appId_$eq((String)applicationStart.appId().getOrElse((Function0 & Serializable)() -> "noAppId"));
        this.appName_$eq(applicationStart.appName());
        Point point = Point.measurement((String)"applications_started").tag("applicationId", this.appId()).tag("spark.app.name", this.appName()).tag("spark.dynamicAllocation.enabled", this.dynamicAllocationEnabled()).time(applicationStart.time(), TimeUnit.MILLISECONDS).field("startTime", (Object)BoxesRunTime.boxToLong((long)this.conf.getLong("spark.app.startTime", 0L))).field("submitTime", (Object)BoxesRunTime.boxToLong((long)this.conf.getLong("spark.app.submitTime", 0L))).field("totalCoresRequested", (Object)BoxesRunTime.boxToLong((long)this.conf.getLong("spark.cores.max", 0L))).field("sparkDriverHost", (Object)this.conf.get("spark.driver.host", "")).field("sparkDriverPort", (Object)BoxesRunTime.boxToInteger((int)this.conf.getInt("spark.driver.port", 0))).field("deployMode", (Object)this.conf.get("spark.submit.deployMode", "")).build();
        this.database().write(point);
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.logger().info(new StringBuilder(67).append("Spark application ended, timestamp = ").append(applicationEnd.time()).append(", closing InfluxDB connection.").toString());
        Point point = Point.measurement((String)"applications_ended").tag("applicationId", this.appId()).tag("spark.app.name", this.appName()).tag("spark.dynamicAllocation.enabled", this.dynamicAllocationEnabled()).time(applicationEnd.time(), TimeUnit.MILLISECONDS).field("duration", (Object)BoxesRunTime.boxToLong((long)((applicationEnd.time() - this.conf.getLong("spark.app.startTime", 0L)) / 1000L))).build();
        this.database().write(point);
        this.influxDB().close();
    }

    public InfluxDBSink(SparkConf conf) {
        String string;
        this.conf = conf;
        this.logger().warn("Custom monitoring listener with InfluxDB sink initializing. Now attempting to connect to InfluxDB");
        this.url = Utils$.MODULE$.parseInfluxDBURL(conf, this.logger());
        Tuple2<String, String> tuple2 = Utils$.MODULE$.parseInfluxDBCredentials(conf, this.logger());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String username = (String)tuple2._1();
        String password = (String)tuple2._2();
        this.x$1 = new Tuple2((Object)username, (Object)password);
        this.username = (String)this.x$1._1();
        this.password = (String)this.x$1._2();
        String string2 = this.username();
        switch (string2 == null ? 0 : string2.hashCode()) {
            default: 
        }
        this.influxDB = string2.isEmpty() ? InfluxDBFactory.connect((String)this.url()) : InfluxDBFactory.connect((String)this.url(), (String)this.username(), (String)this.password());
        this.dbName = Utils$.MODULE$.parseInfluxDBName(conf, this.logger());
        if (!this.influxDB().databaseExists(this.dbName())) {
            this.influxDB().createDatabase(this.dbName());
        }
        this.database = this.influxDB().setDatabase(this.dbName());
        this.logger().info(new StringBuilder(24).append("using InfluxDB database ").append(this.dbName()).toString());
        this.logStageMetrics = Utils$.MODULE$.parseInfluxDBStagemetrics(conf, this.logger());
        this.enableBatch = conf.getBoolean("spark.sparkmeasure.influxdbEnableBatch", true);
        Object object = this.enableBatch() ? this.influxDB().enableBatch(BatchOptions.DEFAULTS.actions(1000).flushDuration(1000)) : BoxedUnit.UNIT;
        this.appId = "noAppId";
        this.appName = "noAppName";
        this.dynamicAllocationEnabled = conf.get("spark.dynamicAllocation.enabled", "false");
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkSession sparkSession = (SparkSession)some.value();
            string = sparkSession.sparkContext().applicationId();
        } else {
            string = "noAppId";
        }
        this.appId_$eq(string);
    }
}

