/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.IOUtils$;
import ch.cern.sparkmeasure.StageInfoRecorderListener;
import ch.cern.sparkmeasure.Utils$;
import org.apache.spark.SparkConf;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005U3Aa\u0003\u0007\u0001'!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004C\u0003$\u0001\u0011\u0005A\u0005\u0003\u0005(\u0001!\u0015\r\u0011\"\u0001)\u0011\u001dy\u0003A1A\u0005\u0002ABaA\u0010\u0001!\u0002\u0013\t\u0004bB \u0001\u0005\u0004%\t\u0001\r\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u0019\t\u000f\u0005\u0003!\u0019!C\u0001\u0005\"1q\t\u0001Q\u0001\n\rCQ\u0001\u0013\u0001\u0005B%\u0013!D\u00127jO\"$(+Z2pe\u0012,'o\u0015;bO\u0016lU\r\u001e:jGNT!!\u0004\b\u0002\u0019M\u0004\u0018M]6nK\u0006\u001cXO]3\u000b\u0005=\u0001\u0012\u0001B2fe:T\u0011!E\u0001\u0003G\"\u001c\u0001a\u0005\u0002\u0001)A\u0011QCF\u0007\u0002\u0019%\u0011q\u0003\u0004\u0002\u001a'R\fw-Z%oM>\u0014VmY8sI\u0016\u0014H*[:uK:,'/\u0001\u0003d_:4\u0007C\u0001\u000e\"\u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\n\u0005\tZ\"!C*qCJ\\7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011QE\n\t\u0003+\u0001AQ\u0001\u0007\u0002A\u0002e\ta\u0001\\8hO\u0016\u0014X#A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00051z\u0012!B:mMRR\u0017B\u0001\u0018,\u0005\u0019aunZ4fe\u0006iQ.\u001a;sS\u000e\u001chi\u001c:nCR,\u0012!\r\t\u0003emr!aM\u001d\u0011\u0005Q:T\"A\u001b\u000b\u0005Y\u0012\u0012A\u0002\u001fs_>$hHC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQt'\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e8\u00039iW\r\u001e:jGN4uN]7bi\u0002\nq\"\\3ue&\u001c7OR5mK:\fW.Z\u0001\u0011[\u0016$(/[2t\r&dWM\\1nK\u0002\nQ\u0002\u001d:j]R$vn\u0015;e_V$X#A\"\u0011\u0005\u0011+U\"A\u001c\n\u0005\u0019;$a\u0002\"p_2,\u0017M\\\u0001\u000faJLg\u000e\u001e+p'R$w.\u001e;!\u0003Ayg.\u00119qY&\u001c\u0017\r^5p]\u0016sG\r\u0006\u0002K\u001bB\u0011AiS\u0005\u0003\u0019^\u0012A!\u00168ji\")aJ\u0003a\u0001\u001f\u0006q\u0011\r\u001d9mS\u000e\fG/[8o\u000b:$\u0007C\u0001)T\u001b\u0005\t&B\u0001*\u001c\u0003%\u00198\r[3ek2,'/\u0003\u0002U#\nY2\u000b]1sW2K7\u000f^3oKJ\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8F]\u0012\u0004")
public class FlightRecorderStageMetrics
extends StageInfoRecorderListener {
    private Logger logger;
    private final SparkConf conf;
    private final String metricsFormat;
    private final String metricsFilename;
    private final boolean printToStdout;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FlightRecorderStageMetrics flightRecorderStageMetrics = this;
        synchronized (flightRecorderStageMetrics) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String metricsFormat() {
        return this.metricsFormat;
    }

    public String metricsFilename() {
        return this.metricsFilename;
    }

    public boolean printToStdout() {
        return this.printToStdout;
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        block7: {
            this.logger().info(new StringBuilder(37).append("Spark application ended, timestamp = ").append(applicationEnd.time()).toString());
            if (this.printToStdout()) {
                this.logger().info("Printing Stage metrics values serialized to JSON to stdout");
                String stringMetrics = IOUtils$.MODULE$.writeToStringSerializedJSON(this.stageMetricsData());
                Predef$.MODULE$.print((Object)"Stage metrics values serialized to JSON:");
                Predef$.MODULE$.print((Object)stringMetrics);
            }
            if (this.metricsFilename().isEmpty()) {
                this.logger().warn("No Stage Metrics output file written.");
                return;
            }
            String string = this.metricsFormat();
            switch (string == null ? 0 : string.hashCode()) {
                case 3254818: {
                    if (!"java".equals(string)) break;
                    this.logger().warn(new StringBuilder(65).append("Writing Stage Metrics data serialized with java serialization to ").append(this.metricsFilename()).toString());
                    IOUtils$.MODULE$.writeSerialized(this.metricsFilename(), this.stageMetricsData());
                    break block7;
                }
                case 3271912: {
                    if (!"json".equals(string)) break;
                    this.logger().warn(new StringBuilder(49).append("Writing Stage Metrics data serialized as json to ").append(this.metricsFilename()).toString());
                    IOUtils$.MODULE$.writeSerializedJSON(this.metricsFilename(), this.stageMetricsData());
                    break block7;
                }
                case 877703122: {
                    if (!"json_to_hadoop".equals(string)) break;
                    this.logger().warn(new StringBuilder(75).append("Writing Stage Metrics data with json serialization to Hadoop filesystem to ").append(this.metricsFilename()).toString());
                    IOUtils$.MODULE$.writeSerializedJSONToHadoop(this.metricsFilename(), this.stageMetricsData(), this.conf);
                    break block7;
                }
            }
            this.logger().warn("StageMetrics data could not be written");
        }
    }

    public FlightRecorderStageMetrics(SparkConf conf) {
        this.conf = conf;
        super(false, (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        this.metricsFormat = Utils$.MODULE$.parseMetricsFormat(conf, this.logger(), "json");
        this.metricsFilename = Utils$.MODULE$.parseMetricsFilename(conf, this.logger(), "/tmp/stageMetrics_flightRecorder");
        this.printToStdout = Utils$.MODULE$.parsePrintToStdout(conf, this.logger(), false);
    }
}

