/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.util.concurrent.atomic.AtomicLong;

public class S3ATimeInstrumentation {
    private static AtomicLong timeElapsedReadMusec = new AtomicLong();
    private static AtomicLong timeElapsedSeekMusec = new AtomicLong();
    private static AtomicLong timeCPUDuringReadMusec = new AtomicLong();
    private static AtomicLong timeCPUDuringSeekMusec = new AtomicLong();
    private static AtomicLong timeGetObjectMetadata = new AtomicLong();
    private static AtomicLong timeCPUGetObjectMetadata = new AtomicLong();
    private static AtomicLong bytesRead = new AtomicLong();

    public static void incrementTimeElapsedReadOps(Long l) {
        timeElapsedReadMusec.getAndAdd(l);
    }

    public static void incrementCPUTimeDuringRead(Long l) {
        timeCPUDuringReadMusec.getAndAdd(l);
    }

    public static void incrementCPUTimeDuringSeek(Long l) {
        timeCPUDuringSeekMusec.getAndAdd(l);
    }

    public static void incrementTimeElapsedSeekOps(Long l) {
        timeElapsedSeekMusec.getAndAdd(l);
    }

    public static void incrementTimeGetObjectMetadata(Long l) {
        timeGetObjectMetadata.getAndAdd(l);
    }

    public static void incrementTimeCPUGetObjectMetadata(Long l) {
        timeCPUGetObjectMetadata.getAndAdd(l);
    }

    public static void incrementBytesRead(Long l) {
        bytesRead.getAndAdd(l);
    }

    public static long getTimeElapsedSeekMusec() {
        return timeElapsedSeekMusec.get();
    }

    public static long getCPUTimeDuringReadMusec() {
        return timeCPUDuringReadMusec.get();
    }

    public static long getTimeElapsedReadMusec() {
        return timeElapsedReadMusec.get();
    }

    public static long getCPUTimeDuringSeekMusec() {
        return timeCPUDuringSeekMusec.get();
    }

    public static long getTimeGetObjectMetadata() {
        return timeGetObjectMetadata.get();
    }

    public static long getTimeCPUGetObjectMetadata() {
        return timeCPUGetObjectMetadata.get();
    }

    public static long getBytesRead() {
        return bytesRead.get();
    }
}

