/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class HDFSTimeInstrumentation {
    private static AtomicLong timeElapsedReadMusec = new AtomicLong();
    private static AtomicLong timeElapsedWriteMusec = new AtomicLong();
    private static AtomicLong timeCPUDuringReadMusec = new AtomicLong();
    private static AtomicInteger readCalls = new AtomicInteger();
    private static AtomicInteger writeCalls = new AtomicInteger();
    private static AtomicLong bytesRead = new AtomicLong();
    private static AtomicLong bytesWritten = new AtomicLong();

    public static long getTimeElapsedReadMusec() {
        return timeElapsedReadMusec.get();
    }

    public static void incrementTimeElapsedReadOps(Long l) {
        timeElapsedReadMusec.getAndAdd(l);
    }

    public static long getCPUTimeDuringReadMusec() {
        return timeCPUDuringReadMusec.get();
    }

    public static void incrementCPUTimeDuringRead(Long l) {
        timeCPUDuringReadMusec.getAndAdd(l);
    }

    public static long getTimeElapsedWriteMusec() {
        return timeElapsedWriteMusec.get();
    }

    public static void incrementTimeElapsedWriteOps(Long l) {
        timeElapsedWriteMusec.getAndAdd(l);
    }

    public static long getBytesRead() {
        return bytesRead.get();
    }

    public static void incrementBytesRead(Long l) {
        bytesRead.getAndAdd(l);
    }

    public static long getBytesWritten() {
        return bytesWritten.get();
    }

    public static void incrementBytesWritten(Long l) {
        bytesWritten.getAndAdd(l);
    }

    public static int getReadCalls() {
        return readCalls.get();
    }

    public static void incrementReadCalls(int n) {
        readCalls.getAndAdd(n);
    }

    public static int getWriteCalls() {
        return writeCalls.get();
    }

    public static void incrementWriteCalls(int n) {
        writeCalls.getAndAdd(n);
    }
}

