/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskFailedReason;
import org.apache.spark.api.plugin.DriverPlugin;
import org.apache.spark.api.plugin.ExecutorPlugin;
import org.apache.spark.api.plugin.PluginContext;
import org.apache.spark.api.plugin.SparkPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q3A\u0001C\u0005\u0001\u001d!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0003Q\u0003B\u0002\u001c\u0001A\u0003%1\u0006\u0003\u00058\u0001!\u0015\r\u0011\"\u00019\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u0015y\u0005\u0001\"\u0011Q\u00059\u0019En\\;e\rNkU\r\u001e:jGNT!AC\u0006\u0002\t\r,'O\u001c\u0006\u0002\u0019\u0005\u00111\r[\u0002\u0001'\r\u0001qb\u0006\t\u0003!Ui\u0011!\u0005\u0006\u0003%M\tA\u0001\\1oO*\tA#\u0001\u0003kCZ\f\u0017B\u0001\f\u0012\u0005\u0019y%M[3diB\u0011\u0001dI\u0007\u00023)\u0011!dG\u0001\u0007a2,x-\u001b8\u000b\u0005qi\u0012aA1qS*\u0011adH\u0001\u0006gB\f'o\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014x-\u0003\u0002%3\tY1\u000b]1sWBcWoZ5o\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\t\u0011\"A\u0005gg6+GO]5dgV\t1\u0006E\u0002-cMj\u0011!\f\u0006\u0003]=\n!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a.\u0005\r\u0019V-\u001d\t\u0003!QJ!!N\t\u0003\rM#(/\u001b8h\u0003)17/T3ue&\u001c7\u000fI\u0001\u0007Y><w-\u001a:\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001P\u0011\u0002\u000bMdg\r\u000e6\n\u0005yZ$A\u0002'pO\u001e,'/\u0001\fdY>,HMR5mKNL8\u000f^3n\u001b\u0016$(/[2t)\t\tU\t\u0005\u0002C\u00076\tq&\u0003\u0002E_\t!QK\\5u\u0011\u00151U\u00011\u0001H\u0003%i\u0017pQ8oi\u0016DH\u000f\u0005\u0002\u0019\u0011&\u0011\u0011*\u0007\u0002\u000e!2,x-\u001b8D_:$X\r\u001f;\u0002\u0019\u0011\u0014\u0018N^3s!2,x-\u001b8\u0015\u00031\u0003\"\u0001G'\n\u00059K\"\u0001\u0004#sSZ,'\u000f\u00157vO&t\u0017AD3yK\u000e,Ho\u001c:QYV<\u0017N\u001c\u000b\u0002#B\u0011\u0001DU\u0005\u0003'f\u0011a\"\u0012=fGV$xN\u001d)mk\u001eLg\u000e")
public class CloudFSMetrics
implements SparkPlugin {
    private Logger logger;
    private final Seq<String> fsMetrics = (Seq)new .colon.colon((Object)"bytesRead", (List)new .colon.colon((Object)"bytesWritten", (List)new .colon.colon((Object)"readOps", (List)new .colon.colon((Object)"writeOps", (List)Nil$.MODULE$))));
    private volatile boolean bitmap$0;

    public Seq<String> fsMetrics() {
        return this.fsMetrics;
    }

    private Logger logger$lzycompute() {
        CloudFSMetrics cloudFSMetrics = this;
        synchronized (cloudFSMetrics) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void cloudFilesystemMetrics(PluginContext myContext) {
        Option fsName = myContext.conf().getOption("spark.cernSparkPlugin.cloudFsName");
        if (fsName.isEmpty()) {
            this.logger().error("spark.cernSparkPlugin.cloudFsName needs to be set when using the ch.cern.CloudFSMetrics Plugin.");
            throw new IllegalArgumentException();
        }
        MetricRegistry metricRegistry = myContext.metricRegistry();
        this.fsMetrics().foreach((Function1 & Serializable & scala.Serializable)name -> (Gauge)metricRegistry.register(MetricRegistry.name((String)name, (String[])new String[0]), (Metric)new Gauge<Object>(null, fsName, name){
            private final Option fsName$1;
            private final String name$1;

            public long getValue() {
                StorageStatistics fsStats = FileSystem.getGlobalStorageStatistics().get((String)this.fsName$1.get());
                StorageStatistics storageStatistics = fsStats;
                if (storageStatistics == null) {
                    return 0L;
                }
                return Predef$.MODULE$.Long2long(fsStats.getLong(this.name$1));
            }
            {
                this.fsName$1 = fsName$1;
                this.name$1 = name$1;
            }
        }));
    }

    public DriverPlugin driverPlugin() {
        return new DriverPlugin(this){
            private final /* synthetic */ CloudFSMetrics $outer;

            public void registerMetrics(String x$1, PluginContext x$2) {
                super.registerMetrics(x$1, x$2);
            }

            public Object receive(Object x$1) throws Exception {
                return super.receive(x$1);
            }

            public void shutdown() {
                super.shutdown();
            }

            public java.util.Map<String, String> init(SparkContext sc, PluginContext myContext) {
                block0: {
                    boolean registerOnDriver = myContext.conf().getBoolean("spark.cernSparkPlugin.registerOnDriver", true);
                    if (!registerOnDriver) break block0;
                    this.$outer.cloudFilesystemMetrics(myContext);
                }
                return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public ExecutorPlugin executorPlugin() {
        return new ExecutorPlugin(this){
            private final /* synthetic */ CloudFSMetrics $outer;

            public void shutdown() {
                super.shutdown();
            }

            public void onTaskStart() {
                super.onTaskStart();
            }

            public void onTaskSucceeded() {
                super.onTaskSucceeded();
            }

            public void onTaskFailed(TaskFailedReason x$1) {
                super.onTaskFailed(x$1);
            }

            public void init(PluginContext myContext, java.util.Map<String, String> extraConf) {
                this.$outer.cloudFilesystemMetrics(myContext);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

