/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskFailedReason;
import org.apache.spark.api.plugin.DriverPlugin;
import org.apache.spark.api.plugin.ExecutorPlugin;
import org.apache.spark.api.plugin.PluginContext;
import org.apache.spark.api.plugin.SparkPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Y3A\u0001C\u0005\u0001\u001d!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0003Q\u0003B\u0002\u001d\u0001A\u0003%1\u0006\u0003\u0005:\u0001!\u0015\r\u0011\"\u0001;\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015\t\u0006\u0001\"\u0011S\u00059\u0019En\\;e\rNkU\r\u001e:jGNT!AC\u0006\u0002\t\r,'O\u001c\u0006\u0002\u0019\u0005\u00111\r[\u0002\u0001'\r\u0001qb\u0006\t\u0003!Ui\u0011!\u0005\u0006\u0003%M\tA\u0001\\1oO*\tA#\u0001\u0003kCZ\f\u0017B\u0001\f\u0012\u0005\u0019y%M[3diB\u0011\u0001dI\u0007\u00023)\u0011!dG\u0001\u0007a2,x-\u001b8\u000b\u0005qi\u0012aA1qS*\u0011adH\u0001\u0006gB\f'o\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014x-\u0003\u0002%3\tY1\u000b]1sWBcWoZ5o\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\t\u0011\"A\u0005gg6+GO]5dgV\t1\u0006E\u0002-gUj\u0011!\f\u0006\u0003]=\n\u0011\"[7nkR\f'\r\\3\u000b\u0005A\n\u0014AC2pY2,7\r^5p]*\t!'A\u0003tG\u0006d\u0017-\u0003\u00025[\t\u00191+Z9\u0011\u0005A1\u0014BA\u001c\u0012\u0005\u0019\u0019FO]5oO\u0006Qam]'fiJL7m\u001d\u0011\u0002\r1|wmZ3s+\u0005Y\u0004C\u0001\u001f@\u001b\u0005i$B\u0001 \"\u0003\u0015\u0019HN\u001a\u001bk\u0013\t\u0001UH\u0001\u0004M_\u001e<WM]\u0001\u0017G2|W\u000f\u001a$jY\u0016\u001c\u0018p\u001d;f[6+GO]5dgR\u00111i\u0012\t\u0003\t\u0016k\u0011!M\u0005\u0003\rF\u0012A!\u00168ji\")\u0001*\u0002a\u0001\u0013\u0006IQ._\"p]R,\u0007\u0010\u001e\t\u00031)K!aS\r\u0003\u001bAcWoZ5o\u0007>tG/\u001a=u\u00031!'/\u001b<feBcWoZ5o)\u0005q\u0005C\u0001\rP\u0013\t\u0001\u0016D\u0001\u0007Ee&4XM\u001d)mk\u001eLg.\u0001\bfq\u0016\u001cW\u000f^8s!2,x-\u001b8\u0015\u0003M\u0003\"\u0001\u0007+\n\u0005UK\"AD#yK\u000e,Ho\u001c:QYV<\u0017N\u001c")
public class CloudFSMetrics
implements SparkPlugin {
    private Logger logger;
    private final Seq<String> fsMetrics = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bytesRead", "bytesWritten", "readOps", "writeOps"}));
    private volatile boolean bitmap$0;

    public Seq<String> fsMetrics() {
        return this.fsMetrics;
    }

    private Logger logger$lzycompute() {
        CloudFSMetrics cloudFSMetrics = this;
        synchronized (cloudFSMetrics) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public void cloudFilesystemMetrics(PluginContext myContext) {
        Option fsName = myContext.conf().getOption("spark.cernSparkPlugin.cloudFsName");
        if (fsName.isEmpty()) {
            this.logger().error("spark.cernSparkPlugin.cloudFsName needs to be set when using the ch.cern.CloudFSMetrics Plugin.");
            throw new IllegalArgumentException();
        }
        MetricRegistry metricRegistry = myContext.metricRegistry();
        this.fsMetrics().foreach((Function1 & Serializable)name -> (Gauge)metricRegistry.register(MetricRegistry.name((String)name, (String[])new String[0]), (Metric)new Gauge<Object>(null, fsName, name){
            private final Option fsName$1;
            private final String name$1;

            public long getValue() {
                StorageStatistics fsStats = FileSystem.getGlobalStorageStatistics().get((String)this.fsName$1.get());
                StorageStatistics storageStatistics = fsStats;
                long l = storageStatistics == null ? 0L : Predef$.MODULE$.Long2long(fsStats.getLong(this.name$1));
                return l;
            }
            {
                this.fsName$1 = fsName$1;
                this.name$1 = name$1;
            }
        }));
    }

    public DriverPlugin driverPlugin() {
        return new DriverPlugin(this){
            private final /* synthetic */ CloudFSMetrics $outer;

            public void registerMetrics(String x$1, PluginContext x$2) {
                super.registerMetrics(x$1, x$2);
            }

            public Object receive(Object x$1) throws Exception {
                return super.receive(x$1);
            }

            public void shutdown() {
                super.shutdown();
            }

            public java.util.Map<String, String> init(SparkContext sc, PluginContext myContext) {
                block0: {
                    boolean registerOnDriver = myContext.conf().getBoolean("spark.cernSparkPlugin.registerOnDriver", true);
                    if (!registerOnDriver) break block0;
                    this.$outer.cloudFilesystemMetrics(myContext);
                }
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public ExecutorPlugin executorPlugin() {
        return new ExecutorPlugin(this){
            private final /* synthetic */ CloudFSMetrics $outer;

            public void shutdown() {
                super.shutdown();
            }

            public void onTaskStart() {
                super.onTaskStart();
            }

            public void onTaskSucceeded() {
                super.onTaskSucceeded();
            }

            public void onTaskFailed(TaskFailedReason x$1) {
                super.onTaskFailed(x$1);
            }

            public void init(PluginContext myContext, java.util.Map<String, String> extraConf) {
                this.$outer.cloudFilesystemMetrics(myContext);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

