/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.bootstrap.impl;

import ch.cmbntr.modulizer.bootstrap.Bootstrap;
import ch.cmbntr.modulizer.bootstrap.BootstrapContext;
import ch.cmbntr.modulizer.bootstrap.Launch;
import ch.cmbntr.modulizer.bootstrap.Prepare;
import ch.cmbntr.modulizer.bootstrap.impl.AbstractOperation;
import ch.cmbntr.modulizer.bootstrap.impl.PropertiesContext;
import ch.cmbntr.modulizer.bootstrap.util.ModulizerIO;
import ch.cmbntr.modulizer.bootstrap.util.ModulizerLog;
import ch.cmbntr.modulizer.bootstrap.util.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.UUID;
import java.util.concurrent.Future;

public class BasicBootstrap
extends AbstractOperation
implements Bootstrap {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Resources.Pool handle = Resources.getPoolHandle();
        try {
            this.establishContext();
            this.performSecuritySettings();
            this.initializeLogging();
            Future<ClassLoader> prepareLoader = this.preparePluginLoader(handle);
            Future<ClassLoader> launchLoader = this.launchPluginLoader(handle);
            this.prepare(prepareLoader);
            this.launch(launchLoader);
        }
        finally {
            this.clearContext();
            Resources.dispose(handle);
        }
    }

    private void performSecuritySettings() {
        try {
            if (!Boolean.parseBoolean(BasicBootstrap.lookupContext("modulizer.bootstrap.security.skip"))) {
                BasicBootstrap.log("applying security settings", new Object[0]);
                System.setSecurityManager(null);
            }
        }
        catch (SecurityException e) {
            BasicBootstrap.warn("failed to apply security settings: %s", e);
        }
    }

    private void establishContext() {
        InputStream config = BasicBootstrap.class.getResourceAsStream("/bootstrap-config.xml");
        if (config == null) {
            BasicBootstrap.warn("config not found: %s", "/bootstrap-config.xml");
        }
        try {
            PropertiesContext ctx = PropertiesContext.empty().loadFromXML(config).addSystemProperties();
            ctx.put("modulizer.bootstrap.app.id", this.sanitizeAppId(ctx));
            ctx.put("modulizer.bootstrap.app.dir", this.sanitizeAppDir(ctx));
            BootstrapContext.CURRENT.set(ctx);
        }
        catch (InvalidPropertiesFormatException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ModulizerIO.closeQuietly(config);
        }
    }

    private void initializeLogging() {
        String loggingConfig = BasicBootstrap.lookupContext("modulizer.logging");
        if ("app.dir".equals(loggingConfig)) {
            loggingConfig = "file:" + BasicBootstrap.lookupContext("modulizer.bootstrap.app.dir") + "/.bootstrap.log";
        }
        ModulizerLog.initLogging(loggingConfig);
    }

    private String sanitizeAppId(PropertiesContext ctx) {
        String given = ctx.get("modulizer.bootstrap.app.id");
        return given == null ? "unnamed-" + UUID.randomUUID() : given.trim();
    }

    private String sanitizeAppDir(PropertiesContext ctx) throws IOException {
        String given = ctx.get("modulizer.bootstrap.app.dir");
        return this.ensureAppDir(given == null ? this.determineDefaultAppDir(ctx) : new File(given));
    }

    private File determineBootstrapBaseDir(PropertiesContext ctx) {
        String baseDir = ctx.get("modulizer.bootstrap.base.dir");
        return new File(baseDir == null ? System.getProperty("java.io.tmpdir") : baseDir);
    }

    private File determineDefaultAppDir(PropertiesContext ctx) {
        String appId = ctx.get("modulizer.bootstrap.app.id");
        File appDir = new File(this.determineBootstrapBaseDir(ctx), appId);
        String slot = ctx.get("modulizer.bootstrap.app.dir.slot");
        return slot == null ? appDir : new File(appDir, slot.trim());
    }

    private String ensureAppDir(File appDir) throws IOException {
        ModulizerIO.mkdir(appDir);
        return appDir.getCanonicalFile().getAbsolutePath();
    }

    private Future<ClassLoader> preparePluginLoader(Resources.Pool handle) {
        return BasicBootstrap.pluginLoaderViaSpecKey(handle, "modulizer.bootstrap.prepare.plugins");
    }

    private void prepare(Future<ClassLoader> loader) {
        BasicBootstrap.invokePluginOperations(Prepare.class, loader);
    }

    private Future<ClassLoader> launchPluginLoader(Resources.Pool handle) {
        return BasicBootstrap.pluginLoaderViaSpecKey(handle, "modulizer.bootstrap.launch.plugins");
    }

    private void launch(Future<ClassLoader> loader) {
        BasicBootstrap.invokePluginOperations(Launch.class, loader);
    }

    private void clearContext() {
        BootstrapContext ctxt = BootstrapContext.CURRENT.getAndSet(null);
        BasicBootstrap.log("final context: %s", ctxt);
    }
}

