/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.bootstrap.impl;

import ch.cmbntr.modulizer.bootstrap.Bootstrap;
import ch.cmbntr.modulizer.bootstrap.BootstrapContext;
import ch.cmbntr.modulizer.bootstrap.Launch;
import ch.cmbntr.modulizer.bootstrap.Prepare;
import ch.cmbntr.modulizer.bootstrap.impl.AbstractOperation;
import ch.cmbntr.modulizer.bootstrap.impl.PropertiesContext;
import ch.cmbntr.modulizer.bootstrap.util.ModulizerIO;
import ch.cmbntr.modulizer.bootstrap.util.ModulizerLog;
import ch.cmbntr.modulizer.bootstrap.util.Resources;
import ch.cmbntr.modulizer.bootstrap.util.SystemPropertyHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;

public class BasicBootstrap
extends AbstractOperation
implements Bootstrap {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Resources.Pool handle = Resources.getPoolHandle();
        try {
            this.establishInitialContext();
            this.performSecuritySettings();
            this.handleSystemProperties();
            this.sanitizeContext();
            this.initializeLogging();
            this.exportProperties();
            this.verboseLoading();
            this.preloading();
            Future<ClassLoader> prepareLoader = this.preparePluginLoader(handle);
            Future<ClassLoader> launchLoader = this.launchPluginLoader(handle);
            this.prepare(prepareLoader);
            this.launch(launchLoader);
            this.scheduleGC();
        }
        finally {
            this.clearContext();
            Resources.dispose(handle);
        }
    }

    private void establishInitialContext() {
        InputStream config = BasicBootstrap.class.getResourceAsStream("/bootstrap-config.xml");
        if (config == null) {
            BasicBootstrap.warn("config not found: %s", "/bootstrap-config.xml");
        }
        try {
            PropertiesContext ctx = PropertiesContext.empty().loadFromXML(config);
            ctx.put("modulizer.bootstrap.uuid", UUID.randomUUID().toString());
            BootstrapContext.CURRENT.set(ctx);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ModulizerIO.closeQuietly(config);
        }
    }

    private void performSecuritySettings() {
        try {
            if (!Boolean.parseBoolean(BasicBootstrap.lookupContext("modulizer.bootstrap.security.skip"))) {
                BasicBootstrap.log("applying security settings", new Object[0]);
                System.setSecurityManager(null);
            }
        }
        catch (SecurityException e) {
            BasicBootstrap.warn("failed to apply security settings: %s", e);
        }
    }

    private void handleSystemProperties() {
        BasicBootstrap.setSystemPropertiesFromArgs();
        BootstrapContext ctx = BootstrapContext.CURRENT.get();
        if (ctx instanceof PropertiesContext) {
            ((PropertiesContext)ctx).addSystemProperties();
        }
    }

    private void sanitizeContext() {
        BootstrapContext ctx = BootstrapContext.CURRENT.get();
        ctx.put("modulizer.bootstrap.app.id", this.sanitizeAppId(ctx));
        try {
            ctx.put("modulizer.bootstrap.app.dir", this.sanitizeAppDir(ctx));
        }
        catch (IOException e) {
            BasicBootstrap.warn("failed to sanitize %s: %s", "modulizer.bootstrap.app.dir", e);
        }
    }

    private void initializeLogging() {
        String loggingConfig = BasicBootstrap.lookupContext("modulizer.logging");
        if ("app.dir".equals(loggingConfig)) {
            loggingConfig = "file:" + BasicBootstrap.lookupContext("modulizer.bootstrap.app.dir") + "/bootstrap.log";
            BasicBootstrap.putContext("modulizer.logging", loggingConfig);
        }
        ModulizerLog.initLogging(loggingConfig);
    }

    private void exportProperties() {
        BootstrapContext ctx = BootstrapContext.CURRENT.get();
        this.export(ctx, "modulizer.bootstrap.uuid");
        this.export(ctx, "modulizer.bootstrap.app.id");
        this.export(ctx, "modulizer.bootstrap.app.dir");
        this.export(ctx, "modulizer.logging");
    }

    private void export(BootstrapContext ctx, String key) {
        String val = (String)ctx.get(key);
        if (val != null) {
            SystemPropertyHelper.export(key, val);
        }
    }

    private void verboseLoading() {
        String val = BasicBootstrap.lookupContext("modulizer.bootstrap.verbose-loading.millis");
        long verboseLoadingMillis = val == null ? -1L : Long.parseLong(val);
        BasicBootstrap.verboseClassloading(verboseLoadingMillis);
    }

    private static void verboseClassloading(long durationMillis) {
        if (durationMillis > 0L) {
            ManagementFactory.getClassLoadingMXBean().setVerbose(true);
            Resources.delay(durationMillis, new Runnable(){

                @Override
                public void run() {
                    ManagementFactory.getClassLoadingMXBean().setVerbose(false);
                }
            });
        }
    }

    private void preloading() {
        this.preload(false, BasicBootstrap.lookupContext("modulizer.bootstrap.preload"));
        this.preload(true, BasicBootstrap.lookupContext("modulizer.bootstrap.preload-gui"));
    }

    private String sanitizeAppId(BootstrapContext ctx) {
        String given = (String)ctx.get("modulizer.bootstrap.app.id");
        return given == null ? "unnamed-" + (String)ctx.get("modulizer.bootstrap.uuid") : given.trim();
    }

    private String sanitizeAppDir(BootstrapContext ctx) throws IOException {
        String given = (String)ctx.get("modulizer.bootstrap.app.dir");
        return this.ensureAppDir(given == null ? this.determineDefaultAppDir(ctx) : new File(given));
    }

    private File determineBootstrapBaseDir(BootstrapContext ctx) {
        String baseDir = (String)ctx.get("modulizer.bootstrap.base.dir");
        return new File(baseDir == null ? System.getProperty("java.io.tmpdir") : baseDir);
    }

    private File determineDefaultAppDir(BootstrapContext ctx) {
        String appId = (String)ctx.get("modulizer.bootstrap.app.id");
        File appDir = new File(this.determineBootstrapBaseDir(ctx), appId);
        String slot = (String)ctx.get("modulizer.bootstrap.app.dir.slot");
        return slot == null ? appDir : new File(appDir, slot.trim());
    }

    private String ensureAppDir(File appDir) throws IOException {
        ModulizerIO.mkdir(appDir);
        return appDir.getCanonicalFile().getAbsolutePath();
    }

    private Future<ClassLoader> preparePluginLoader(Resources.Pool handle) {
        return BasicBootstrap.pluginLoaderViaSpecKey(handle, "modulizer.bootstrap.prepare.plugins");
    }

    private void prepare(Future<ClassLoader> loader) {
        BasicBootstrap.invokePluginOperations(true, Prepare.class, loader);
    }

    private Future<ClassLoader> launchPluginLoader(Resources.Pool handle) {
        return BasicBootstrap.pluginLoaderViaSpecKey(handle, "modulizer.bootstrap.launch.plugins");
    }

    private void launch(Future<ClassLoader> loader) {
        BasicBootstrap.invokePluginOperations(false, Launch.class, loader);
    }

    private void scheduleGC() {
        String val = BasicBootstrap.lookupContext("modulizer.bootstrap.gc.delay-millis");
        long delay = val == null ? 8000L : Long.parseLong(val);
        BasicBootstrap.delayedGC(delay);
    }

    private static void delayedGC(long delay) {
        if (delay >= 0L) {
            Resources.delay(delay, new Runnable(){

                @Override
                public void run() {
                    ManagementFactory.getMemoryMXBean().gc();
                }
            });
        }
    }

    private void clearContext() {
        BootstrapContext ctxt = BootstrapContext.CURRENT.getAndSet(null);
        BasicBootstrap.log("final context: %s", ctxt);
    }

    private static void setSystemPropertiesFromArgs() {
        String[] args = BootstrapContext.ARGS.get();
        if (args != null && args.length > 1 && "--systemProperties".equals(args[0])) {
            Properties props = BasicBootstrap.decodeProperties(args[1]);
            for (Map.Entry<Object, Object> p : props.entrySet()) {
                String k = p.getKey().toString();
                String v = p.getValue().toString();
                System.setProperty(k, v);
                BasicBootstrap.log("set system property %s to %s", k, v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties decodeProperties(String encoded) {
        Properties p = new Properties();
        try {
            String dec = URLDecoder.decode(encoded.trim(), "UTF-8");
            ByteArrayInputStream is = new ByteArrayInputStream(dec.getBytes("UTF-8"));
            try {
                p.loadFromXML(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            BasicBootstrap.warn("properties decoding failed: %s", e);
        }
        return p;
    }
}

