/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.filetree;

import ch.cmbntr.modulizer.filetree.FileTreeUtil;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.BundleWriter;

public class Snapshot {
    private static final Logger LOG = Logger.getAnonymousLogger();

    private Snapshot() {
    }

    private static void log(String msg, Object ... args) {
        LOG.fine(String.format(msg, args));
    }

    public static String sanitizeHeadRef(String bundleRef) {
        String headsNamespace = "refs/heads/";
        String ref = bundleRef.replace('\\', '/');
        return ref.contains("refs/heads/") ? ref : "refs/heads/" + bundleRef;
    }

    public static void main(String[] args) throws Exception {
        File here = new File(".").getCanonicalFile().getAbsoluteFile();
        File bundle = new File(FileTreeUtil.timestamp() + ".bundle");
        System.out.format("Created snapshot %s of %s to %s", Snapshot.createBundle(bundle, here, "master"), here, bundle);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createBundle(File bundle, File worktree, String bundleRef) {
        try {
            File dir = worktree.getCanonicalFile().getAbsoluteFile();
            Git git = Git.init().setDirectory(dir).call();
            AddCommand add = git.add();
            for (File f : dir.listFiles()) {
                String name = f.getName();
                if (".git".equals(name)) continue;
                Snapshot.log("adding %s", name);
                add.addFilepattern(name);
            }
            DirCache index = add.call();
            int cnt = index.getEntryCount();
            Snapshot.log("%d entries added", cnt);
            String msg = "snapshot";
            RevCommit head = git.commit().setMessage("snapshot").call();
            BundleWriter bw = new BundleWriter(git.getRepository());
            bw.include(Snapshot.sanitizeHeadRef(bundleRef), head);
            FileOutputStream out = new FileOutputStream(bundle);
            try {
                bw.writeBundle(Snapshot.createProgressMonitor(), out);
            }
            finally {
                out.close();
            }
            return head.getId().getName();
        }
        catch (NoFilepatternException e) {
            throw Snapshot.failCreateBundle(e);
        }
        catch (NoHeadException e) {
            throw Snapshot.failCreateBundle(e);
        }
        catch (NoMessageException e) {
            throw Snapshot.failCreateBundle(e);
        }
        catch (UnmergedPathsException e) {
            throw Snapshot.failCreateBundle(e);
        }
        catch (ConcurrentRefUpdateException e) {
            throw Snapshot.failCreateBundle(e);
        }
        catch (WrongRepositoryStateException e) {
            throw Snapshot.failCreateBundle(e);
        }
        catch (IOException e) {
            throw Snapshot.failCreateBundle(e);
        }
        catch (GitAPIException e) {
            throw Snapshot.failCreateBundle(e);
        }
    }

    private static ProgressMonitor createProgressMonitor() {
        Console con = System.console();
        return con == null ? NullProgressMonitor.INSTANCE : new TextProgressMonitor(con.writer());
    }

    private static RuntimeException failCreateBundle(Throwable cause) {
        throw new FileTreeSnapshotException(cause);
    }

    public static class FileTreeSnapshotException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public FileTreeSnapshotException(Throwable cause) {
            super(cause);
        }
    }
}

