/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.storage.dfs.DfsInserter;
import org.eclipse.jgit.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.storage.dfs.DfsPackFile;
import org.eclipse.jgit.storage.dfs.DfsPacksChangedEvent;
import org.eclipse.jgit.storage.dfs.DfsReader;
import org.eclipse.jgit.storage.dfs.DfsReaderOptions;
import org.eclipse.jgit.storage.dfs.DfsRepository;
import org.eclipse.jgit.storage.dfs.ReadableChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfsObjDatabase
extends ObjectDatabase {
    private static final PackList NO_PACKS = new PackList(new DfsPackFile[0]);
    private final AtomicReference<PackList> packList;
    private final DfsRepository repository;
    private DfsReaderOptions readerOptions;

    protected DfsObjDatabase(DfsRepository repository, DfsReaderOptions options) {
        this.repository = repository;
        this.packList = new AtomicReference<PackList>(NO_PACKS);
        this.readerOptions = options;
    }

    public DfsReaderOptions getReaderOptions() {
        return this.readerOptions;
    }

    @Override
    public ObjectReader newReader() {
        return new DfsReader(this);
    }

    @Override
    public ObjectInserter newInserter() {
        return new DfsInserter(this);
    }

    public DfsPackFile[] getPacks() throws IOException {
        return this.scanPacks((PackList)DfsObjDatabase.NO_PACKS).packs;
    }

    protected DfsRepository getRepository() {
        return this.repository;
    }

    public DfsPackFile[] getCurrentPacks() {
        return this.packList.get().packs;
    }

    protected abstract DfsPackDescription newPack(PackSource var1) throws IOException;

    protected void commitPack(Collection<DfsPackDescription> desc, Collection<DfsPackDescription> replaces) throws IOException {
        this.commitPackImpl(desc, replaces);
        this.getRepository().fireEvent(new DfsPacksChangedEvent());
    }

    protected abstract void commitPackImpl(Collection<DfsPackDescription> var1, Collection<DfsPackDescription> var2) throws IOException;

    protected abstract void rollbackPack(Collection<DfsPackDescription> var1);

    protected abstract List<DfsPackDescription> listPacks() throws IOException;

    protected abstract ReadableChannel openPackFile(DfsPackDescription var1) throws FileNotFoundException, IOException;

    protected abstract ReadableChannel openPackIndex(DfsPackDescription var1) throws FileNotFoundException, IOException;

    protected abstract DfsOutputStream writePackFile(DfsPackDescription var1) throws IOException;

    protected abstract DfsOutputStream writePackIndex(DfsPackDescription var1) throws IOException;

    void addPack(DfsPackFile newPack) throws IOException {
        DfsPackFile[] packs;
        PackList n;
        PackList o;
        do {
            if ((o = this.packList.get()) == NO_PACKS) {
                o = this.scanPacks(o);
                for (DfsPackFile p : o.packs) {
                    if (p != newPack) continue;
                    return;
                }
            }
            packs = new DfsPackFile[1 + o.packs.length];
            packs[0] = newPack;
            System.arraycopy(o.packs, 0, packs, 1, o.packs.length);
        } while (!this.packList.compareAndSet(o, n = new PackList(packs)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackList scanPacks(PackList original) throws IOException {
        PackList n;
        AtomicReference<PackList> atomicReference = this.packList;
        synchronized (atomicReference) {
            PackList o;
            do {
                if ((o = this.packList.get()) != original) {
                    return o;
                }
                n = this.scanPacksImpl(o);
                if (n != o) continue;
                return n;
            } while (!this.packList.compareAndSet(o, n));
        }
        this.getRepository().fireEvent(new DfsPacksChangedEvent());
        return n;
    }

    private PackList scanPacksImpl(PackList old) throws IOException {
        DfsBlockCache cache = DfsBlockCache.getInstance();
        Map<DfsPackDescription, DfsPackFile> forReuse = DfsObjDatabase.reuseMap(old);
        List<DfsPackDescription> scanned = this.listPacks();
        Collections.sort(scanned);
        ArrayList<DfsPackFile> list = new ArrayList<DfsPackFile>(scanned.size());
        boolean foundNew = false;
        for (DfsPackDescription dsc : scanned) {
            DfsPackFile oldPack = forReuse.remove(dsc);
            if (oldPack != null) {
                list.add(oldPack);
                continue;
            }
            list.add(cache.getOrCreate(dsc, null));
            foundNew = true;
        }
        for (DfsPackFile p : forReuse.values()) {
            p.close();
        }
        if (list.isEmpty()) {
            return new PackList(DfsObjDatabase.NO_PACKS.packs);
        }
        if (!foundNew) {
            return old;
        }
        return new PackList(list.toArray(new DfsPackFile[list.size()]));
    }

    private static Map<DfsPackDescription, DfsPackFile> reuseMap(PackList old) {
        HashMap<DfsPackDescription, DfsPackFile> forReuse = new HashMap<DfsPackDescription, DfsPackFile>();
        for (DfsPackFile p : old.packs) {
            if (p.invalid()) {
                p.close();
                continue;
            }
            DfsPackFile prior = forReuse.put(p.getPackDescription(), p);
            if (prior == null) continue;
            forReuse.put(prior.getPackDescription(), prior);
            p.close();
        }
        return forReuse;
    }

    protected void clearCache() {
        this.packList.set(NO_PACKS);
    }

    @Override
    public void close() {
        this.packList.set(NO_PACKS);
    }

    private static final class PackList {
        final DfsPackFile[] packs;

        PackList(DfsPackFile[] packs) {
            this.packs = packs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PackSource {
        INSERT,
        RECEIVE,
        GC,
        COMPACT,
        UNREACHABLE_GARBAGE;

    }
}

