/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.modules;

import ch.cmbntr.modulizer.bootstrap.util.ModulizerLog;
import ch.cmbntr.modulizer.bootstrap.util.Resources;
import ch.cmbntr.modulizer.bootstrap.util.SystemPropertyHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.modules.LocalModuleLoader;
import org.jboss.modules.Main;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;

public class ModulizerModulesUtil {
    private static final Class<?>[] LAUNCH_SIGNATURE = new Class[]{File.class, String.class, String[].class};

    private ModulizerModulesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Module> loadModules(Iterable<String> moduleIdentifiers, File ... repoRoots) {
        Resources.Pool pool = Resources.getPoolHandle();
        ExecutorService exec = pool.aquireExec();
        Properties origProps = SystemPropertyHelper.snapshotProps();
        try {
            final LocalModuleLoader loader = new LocalModuleLoader(repoRoots);
            LinkedList<Future<Module>> asyncModules = new LinkedList<Future<Module>>();
            for (final String moduleIdentifier : moduleIdentifiers) {
                asyncModules.add(exec.submit(new Callable<Module>(){

                    @Override
                    public Module call() throws Exception {
                        return loader.loadModule(ModuleIdentifier.fromString((String)moduleIdentifier));
                    }
                }));
            }
            ArrayList<Module> modules = new ArrayList<Module>(asyncModules.size());
            for (Future future : asyncModules) {
                modules.add((Module)Resources.get((Future)future, (String)"failed to load module"));
            }
            ArrayList<Module> arrayList = modules;
            return arrayList;
        }
        finally {
            SystemPropertyHelper.restoreProps((Properties)origProps);
            pool.releaseExec(exec);
        }
    }

    public static CountDownLatch invokeModulesMain(File modulesRepo, String mainModule, String ... args) {
        return ModulizerModulesUtil.invokeModulesMain(mainModule, modulesRepo, mainModule, args);
    }

    public static CountDownLatch invokeModulesMain(String appName, File modulesRepo, String mainModule, String ... args) {
        String threadName = String.format("main[%s]", appName);
        return ModulizerModulesUtil.invokeModulesMain(threadName, (Thread.UncaughtExceptionHandler)ModulizerLog.ExceptionLogger.create(), modulesRepo, mainModule, args);
    }

    private static CountDownLatch invokeModulesMain(String threadName, Thread.UncaughtExceptionHandler exceptionHandler, File modulesRepo, String mainModule, String ... args) {
        CountDownLatch running = new CountDownLatch(1);
        CountDownLatch done = new CountDownLatch(1);
        ModulizerModulesUtil.startAndAwaitRunning(ModulizerModulesUtil.createThread(threadName, running, done, exceptionHandler, modulesRepo, mainModule, args), running);
        return done;
    }

    private static Thread createThread(String threadName, CountDownLatch running, CountDownLatch done, Thread.UncaughtExceptionHandler exceptionHandler, File modulesRepo, String mainModule, String ... args) {
        Thread t = Resources.newThread((String)threadName, (Runnable)MainRunner.create(running, done, modulesRepo, mainModule, args));
        if (exceptionHandler != null) {
            t.setUncaughtExceptionHandler(exceptionHandler);
        }
        return t;
    }

    private static void startAndAwaitRunning(Thread t, CountDownLatch running) {
        t.start();
        try {
            running.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void invokeModulesMainAndWait(File modulesRepo, String mainModule, String ... args) {
        try {
            Main.main((String[])ModulizerModulesUtil.assembleRunArguments(modulesRepo, mainModule, args));
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static String[] assembleRunArguments(File modulesRepo, String mainModule, String ... args) throws IOException {
        String repoPath = modulesRepo.getCanonicalFile().getAbsolutePath();
        String[] basicArgs = new String[]{"-modulepath", repoPath, mainModule};
        if (args != null) {
            int argsCount = args.length;
            if (args.length > 0) {
                int basicCount = basicArgs.length;
                String[] fullArgs = new String[basicCount + argsCount];
                System.arraycopy(basicArgs, 0, fullArgs, 0, basicCount);
                System.arraycopy(args, 0, fullArgs, basicCount, argsCount);
                return fullArgs;
            }
        }
        return basicArgs;
    }

    public static Method getLaunchMethod(ClassLoader loader, boolean wait) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        Class<?> mmu = loader.loadClass(ModulizerModulesUtil.class.getName());
        return mmu.getMethod(wait ? "invokeModulesMainAndWait" : "invokeModulesMain", LAUNCH_SIGNATURE);
    }

    public static void main(String[] args) throws InterruptedException {
        if (args == null || args.length < 2) {
            System.err.format("Usage: java %s repoPath mainModule [args...]", ModulizerModulesUtil.class.getName());
            System.exit(1);
        } else {
            File repoPath = new File(args[0]);
            String mainModule = args[1];
            String[] moduleArgs = null;
            if (args.length > 2) {
                moduleArgs = new String[args.length - 2];
                System.arraycopy(args, 0, moduleArgs, 0, moduleArgs.length);
            }
            CountDownLatch done = ModulizerModulesUtil.invokeModulesMain(mainModule, repoPath, mainModule, moduleArgs);
            done.await();
            System.exit(0);
        }
    }

    private static final class MainRunner
    implements Runnable {
        private final CountDownLatch running;
        private final CountDownLatch done;
        private final File modulesRepo;
        private final String mainModule;
        private final String[] args;

        private MainRunner(CountDownLatch running, CountDownLatch done, File modulesRepo, String mainModule, String ... args) {
            this.running = running;
            this.done = done;
            this.modulesRepo = modulesRepo;
            this.mainModule = mainModule;
            this.args = args;
        }

        private static Runnable create(CountDownLatch running, CountDownLatch done, File modulesRepo, String mainModule, String ... args) {
            return new MainRunner(running, done, modulesRepo, mainModule, args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.running.countDown();
                ModulizerModulesUtil.invokeModulesMainAndWait(this.modulesRepo, this.mainModule, this.args);
            }
            finally {
                this.done.countDown();
            }
        }
    }
}

