/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin;

import ch.cmbntr.modulizer.bootstrap.util.Resources;
import ch.cmbntr.modulizer.bootstrap.util.SystemPropertyHelper;
import ch.cmbntr.modulizer.bootstrap.util.XMLFactories;
import ch.cmbntr.modulizer.plugin.util.ArtifactInfo;
import ch.cmbntr.modulizer.plugin.util.ArtifactPattern;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractModulizeMojo
extends AbstractMojo {
    private static final Predicate<Artifact> IS_MODULIZER_BOOTSTRAP = ArtifactInfo.createFilter(ArtifactPattern.valueOf("*:modulizer-bootstrap:jar:*:*"));
    private static final Predicate<Artifact> IS_PREPARE_PLUGIN = ArtifactInfo.createFilter(ArtifactPattern.valueOf("*:modulizer-filetree:jar:plugin:*"));
    private static final Predicate<Artifact> IS_LAUNCHER_PLUGIN = ArtifactInfo.createFilter(ArtifactPattern.valueOf("*:modulizer-jboss-modules:jar:plugin:*"));
    private static final Predicate<Artifact> IS_JBOSS_MODULES = ArtifactInfo.createFilter(ArtifactPattern.valueOf("org.jboss.modules:jboss-modules:jar:*:*"));
    @Parameter(property="module", required=true)
    protected String mainModule;
    @Parameter(defaultValue="${project.build.directory}/modules", required=true)
    protected File modulesDirectory;
    @Component
    private MavenProject proj;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    private List<Artifact> pluginDependencies;
    @Parameter(defaultValue="false")
    private boolean brokenXMLFactoriesHack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Resources.Pool handle = Resources.getPoolHandle();
        Thread currentThread = Thread.currentThread();
        ClassLoader origCCL = currentThread.getContextClassLoader();
        Properties origProps = SystemPropertyHelper.snapshotProps();
        try {
            this.brokenXMLFactoriesHack();
            this.checkParams();
            this.safeExecute();
        }
        finally {
            currentThread.setContextClassLoader(origCCL);
            SystemPropertyHelper.restoreProps((Properties)origProps);
            Resources.dispose((Resources.Pool)handle);
        }
    }

    private void brokenXMLFactoriesHack() {
        if (!this.brokenXMLFactoriesHack) {
            return;
        }
        Log log = this.getLog();
        try {
            log.debug((CharSequence)("XMLFactories: " + XMLFactories.inspectXMLFactories()));
        }
        catch (Throwable t) {
            log.error((CharSequence)"broken XMLFactories", t);
            try {
                log.info((CharSequence)"trying fallbacks...");
                XMLFactories.installFallbacks();
                log.error((CharSequence)("fallbacks work: " + XMLFactories.inspectXMLFactories()));
            }
            catch (Throwable tt) {
                log.error((CharSequence)"fallbacks did not work", tt);
            }
        }
    }

    protected void checkParams() {
        Preconditions.checkNotNull((Object)this.mainModule, (Object)"invalid mainModule");
        Preconditions.checkNotNull((Object)this.modulesDirectory, (Object)"invalid modulesDirectory");
    }

    protected Artifact findDependency(Predicate<Artifact> test) throws NoSuchElementException {
        return (Artifact)Iterables.find((Iterable)Iterables.concat((Iterable)this.proj.getDependencyArtifacts(), (Iterable)this.proj.getArtifacts(), this.pluginDependencies), test);
    }

    protected Artifact findModulizerBootstrap() {
        return this.findDependency(IS_MODULIZER_BOOTSTRAP);
    }

    protected Artifact findPreparePlugin() {
        return this.findDependency(IS_PREPARE_PLUGIN);
    }

    protected Artifact findLauncherPlugin() {
        return this.findDependency(IS_LAUNCHER_PLUGIN);
    }

    protected Artifact findJBossModules() {
        return this.findDependency(IS_JBOSS_MODULES);
    }

    protected URL artifactURL(Artifact dep) throws MojoExecutionException {
        try {
            File f = dep.getFile();
            if (f == null) {
                throw new MojoExecutionException(dep + " has no file");
            }
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("failed to get URL for " + dep);
        }
    }

    protected abstract void safeExecute() throws MojoExecutionException, MojoFailureException;
}

