/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin.archiver;

import ch.cmbntr.modulizer.plugin.archiver.ArchiverCallback;
import ch.cmbntr.modulizer.plugin.archiver.ArchiverHelper;
import ch.cmbntr.modulizer.plugin.util.ModulizerUtil;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

@Component(role=ArchiverHelper.class)
public class DefaultArchiverHelper
implements ArchiverHelper {
    private static final String[] MANIFEST_AND_INDEX = new String[]{"META-INF/MANIFEST.MF", "META-INF/INDEX.LIST"};
    private static final Function<File, String> FILE_NAME = new Function<File, String>(){

        public String apply(File f) {
            return f.getName();
        }
    };
    @Requirement
    private Logger logger;
    @Requirement(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;

    private void log(String msg, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format(msg, args));
        }
    }

    @Override
    public void createArchive(MavenSession session, File target, boolean compress, Iterable<? extends ArchiverCallback> callbacks) throws MojoExecutionException {
        MavenArchiver archiver = new MavenArchiver();
        archiver.setOutputFile(target);
        archiver.setArchiver(this.jarArchiver);
        MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
        archive.setCompress(compress);
        archive.setForced(true);
        try {
            JarArchiver container = archiver.getArchiver();
            for (ArchiverCallback archiverCallback : callbacks) {
                archiverCallback.addContents(container);
            }
            archiver.createArchive(session, session.getCurrentProject(), archive);
        }
        catch (ArchiverException e) {
            this.artifactCreationFailure((Exception)((Object)e));
        }
        catch (ManifestException e) {
            this.artifactCreationFailure((Exception)((Object)e));
        }
        catch (IOException e) {
            this.artifactCreationFailure(e);
        }
        catch (DependencyResolutionRequiredException e) {
            this.artifactCreationFailure((Exception)((Object)e));
        }
    }

    private void artifactCreationFailure(Exception e) throws MojoExecutionException {
        throw new MojoExecutionException("could not create artifact", e);
    }

    @Override
    public ArchiverCallback fileAdder(File ... files) {
        return this.fileAdder((Iterable<File>)ImmutableList.copyOf((Object[])files));
    }

    private ArchiverCallback fileAdder(Iterable<File> files) {
        return this.fileAdder(ModulizerUtil.compute(files, FILE_NAME));
    }

    @Override
    public ArchiverCallback fileAdder(final Map<File, String> namedFiles) {
        return new ArchiverCallback(){

            @Override
            public void addContents(JarArchiver archiver) {
                for (Map.Entry e : namedFiles.entrySet()) {
                    File f = (File)e.getKey();
                    String n = (String)e.getValue();
                    DefaultArchiverHelper.this.log("include %s as %s ", new Object[]{f, n});
                    archiver.addFile(f, n);
                }
            }
        };
    }

    @Override
    public ArchiverCallback directoryAdder(File ... directories) {
        return this.directoryAdder((Iterable<File>)ImmutableList.copyOf((Object[])directories));
    }

    private ArchiverCallback directoryAdder(Iterable<File> directories) {
        return this.directoryAdder(ModulizerUtil.compute(directories, Functions.constant((Object)"")));
    }

    @Override
    public ArchiverCallback directoryAdder(final Map<File, String> directoriesWithPrefixes) {
        return new ArchiverCallback(){

            @Override
            public void addContents(JarArchiver archiver) {
                for (Map.Entry e : directoriesWithPrefixes.entrySet()) {
                    File d = (File)e.getKey();
                    String p = (String)e.getValue();
                    DefaultArchiverHelper.this.log("include directory %s with prefix '%s'", new Object[]{d, p});
                    archiver.addDirectory(d, p);
                }
            }
        };
    }

    @Override
    public ArchiverCallback manifest(final Map<String, String> manifestEntries) {
        return new ArchiverCallback(){

            @Override
            public void addContents(JarArchiver archiver) {
                Manifest m = new Manifest();
                Attributes attrs = m.getMainAttributes();
                for (Map.Entry e : manifestEntries.entrySet()) {
                    attrs.putValue((String)e.getKey(), (String)e.getValue());
                }
                try {
                    archiver.addConfiguredManifest(m);
                }
                catch (ManifestException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public ArchiverCallback mergeArtifacts(final File tmpDir, final Iterable<? extends Artifact> merges) {
        return new ArchiverCallback(){

            @Override
            public void addContents(JarArchiver archiver) {
                for (Artifact a : merges) {
                    try {
                        archiver.addFileSet(DefaultArchiverHelper.mergeFileSet(tmpDir, a));
                    }
                    catch (MojoExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
    }

    private static FileSet mergeFileSet(File tmpDir, Artifact a) throws MojoExecutionException {
        File destDirectory = new File(tmpDir, "extract_" + a.getId().replace(':', '_'));
        ModulizerUtil.mkdir(destDirectory);
        ZipUnArchiver unarchiver = DefaultArchiverHelper.unzipperForMerge();
        unarchiver.setOverwrite(true);
        unarchiver.setSourceFile(a.getFile());
        unarchiver.setDestDirectory(destDirectory);
        unarchiver.extract();
        DefaultFileSet files = new DefaultFileSet();
        files.setDirectory(destDirectory);
        return files;
    }

    private static ZipUnArchiver unzipperForMerge() {
        ZipUnArchiver unarchiver = new ZipUnArchiver();
        unarchiver.enableLogging((Logger)new ConsoleLogger(3, "UNZIP"));
        unarchiver.setIgnorePermissions(true);
        unarchiver.setFileSelectors(new FileSelector[]{DefaultArchiverHelper.excludeManifestAndIndex()});
        return unarchiver;
    }

    private static FileSelector excludeManifestAndIndex() {
        IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();
        selector.setUseDefaultExcludes(false);
        selector.setExcludes(MANIFEST_AND_INDEX);
        return selector;
    }
}

