/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin.config;

import ch.cmbntr.modulizer.plugin.config.ConfigBase;
import ch.cmbntr.modulizer.plugin.util.ModuleDescriptors;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class ModuleDependency
extends ConfigBase {
    private String name;
    private String slot;
    private String services = "none";
    private boolean export = false;
    private boolean optional = false;

    public ModuleDependency() {
    }

    protected ModuleDependency(String name, String slot, boolean optional, boolean export, String services) {
        this();
        this.name = name;
        this.slot = slot;
        this.services = services;
        this.export = export;
        this.optional = optional;
    }

    public static ModuleDependency to(String name) {
        return new ModuleDependency(name, null, false, false, "none");
    }

    public static ModuleDependency to(String name, String slot, boolean optional, boolean export, String services) {
        return new ModuleDependency(name, slot, optional, export, services);
    }

    @Override
    public void checkParams() {
        super.checkParams();
        Preconditions.checkState((boolean)ModuleDescriptors.isValidModuleName(this.name), (String)"invalid module name: %s", (Object[])new Object[]{this.name});
        if (this.slot != null) {
            Preconditions.checkState((boolean)ModuleDescriptors.isValidSlotName(this.slot), (String)"invalid slot name: %s", (Object[])new Object[]{this.slot});
        }
        Preconditions.checkState((boolean)ModuleDescriptors.isValidServiceDisposition(this.services), (String)"invalid services dispostition: %s", (Object[])new Object[]{this.services});
    }

    public String getName() {
        return this.name;
    }

    public String getSlot() {
        return this.slot;
    }

    public String getServicesDisposition() {
        return this.services;
    }

    public boolean isExport() {
        return this.export;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    protected Objects.ToStringHelper prepareToStringHelper() {
        return super.prepareToStringHelper().add("name", (Object)this.name).add("slot", (Object)this.slot).add("services", (Object)this.services).add("export", this.export).add("optional", this.optional);
    }
}

