/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin.config;

import ch.cmbntr.modulizer.plugin.config.ConfigBase;
import ch.cmbntr.modulizer.plugin.util.ArtifactInfo;
import ch.cmbntr.modulizer.plugin.util.ArtifactPattern;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class ModuleResources
extends ConfigBase {
    private static final Predicate<ArtifactInfo> IS_NO_TEST = Predicates.not((Predicate)ArtifactPattern.valueOf("*:*:*:*:test"));
    private static final Predicate<ArtifactInfo> IS_NO_POM = Predicates.not((Predicate)ArtifactPattern.valueOf("*:*:pom:*:*"));
    private boolean excludeTest = true;
    private Set<String> includes;
    private Set<String> excludes;

    private Predicate<ArtifactInfo> pred(Set<String> patterns, Predicate<ArtifactInfo> defPredicate) {
        List<ArtifactPattern> preds = ArtifactPattern.createPatterns(patterns);
        if (preds.isEmpty()) {
            return defPredicate;
        }
        return Predicates.or(preds);
    }

    public Predicate<Artifact> getArtifactSelector() {
        LinkedList criteria = Lists.newLinkedList();
        criteria.add(IS_NO_POM);
        if (this.excludeTest) {
            criteria.add(IS_NO_TEST);
        }
        criteria.add(this.pred(this.includes, (Predicate<ArtifactInfo>)Predicates.alwaysTrue()));
        criteria.add(Predicates.not(this.pred(this.excludes, (Predicate<ArtifactInfo>)Predicates.alwaysFalse())));
        return ArtifactInfo.createFilter(criteria);
    }

    @Override
    protected Objects.ToStringHelper prepareToStringHelper() {
        return super.prepareToStringHelper().add("excludeTest", this.excludeTest).add("includes", this.includes).add("excludes", this.excludes);
    }
}

