/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin.util;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.apache.maven.artifact.Artifact;

public class ArtifactInfo {
    private static final Function<Artifact, ArtifactInfo> CREATE = new Function<Artifact, ArtifactInfo>(){

        public ArtifactInfo apply(Artifact a) {
            return ArtifactInfo.from(a);
        }
    };
    final String groupId;
    final String artifactId;
    final String type;
    final String classifier;
    final String scope;

    protected ArtifactInfo(String groupId, String artifactId, String type, String classifier, String scope) {
        this.groupId = groupId != null ? groupId : "";
        this.artifactId = artifactId != null ? artifactId : "";
        this.type = type != null ? type : "";
        this.classifier = classifier != null ? classifier : "";
        this.scope = scope != null ? scope : "";
    }

    public static ArtifactInfo from(Artifact artifact) {
        return new ArtifactInfo(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier(), artifact.getScope());
    }

    public static Predicate<Artifact> createFilter(Predicate<ArtifactInfo> ... criteria) {
        return Predicates.compose((Predicate)Predicates.and(criteria), CREATE);
    }

    public static Predicate<Artifact> createFilter(Iterable<? extends Predicate<ArtifactInfo>> criteria) {
        return Predicates.compose((Predicate)Predicates.and(criteria), CREATE);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("groupId", (Object)this.groupId).add("artifactId", (Object)this.artifactId).add("type", (Object)this.type).add("classifier", (Object)this.classifier).add("scope", (Object)this.scope).toString();
    }
}

