/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin.util;

import ch.cmbntr.modulizer.plugin.util.ArtifactInfo;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import org.codehaus.plexus.util.SelectorUtils;

public class ArtifactPattern
extends ArtifactInfo
implements Predicate<ArtifactInfo> {
    private static final Function<String, ArtifactPattern> CREATE = new Function<String, ArtifactPattern>(){

        public ArtifactPattern apply(String pattern) {
            return ArtifactPattern.valueOf(pattern);
        }
    };

    protected ArtifactPattern(String groupId, String artifactId, String type, String classifier, String scope) {
        super(groupId, artifactId, type, classifier, scope);
    }

    public static ArtifactPattern valueOf(String pattern) {
        String t;
        String[] tokens = new String[]{};
        if (pattern != null && pattern.length() > 0) {
            tokens = pattern.split(":", -1);
        }
        String g = tokens.length > 0 ? tokens[0] : "";
        String a = tokens.length > 1 ? tokens[1] : "*";
        String string = t = tokens.length > 3 ? tokens[2] : "*";
        String c = tokens.length > 3 ? tokens[3] : (tokens.length > 2 ? tokens[2] : "*");
        String s = tokens.length > 4 ? tokens[4] : "*";
        return new ArtifactPattern(g, a, t, c, s);
    }

    public static List<ArtifactPattern> createPatterns(Iterable<String> patterns) {
        ImmutableSet p = patterns == null ? ImmutableSet.of() : ImmutableSet.copyOf(patterns);
        return ImmutableList.copyOf((Collection)Collections2.transform((Collection)p, CREATE));
    }

    public boolean apply(ArtifactInfo a) {
        if (this.matchesNot(this.scope, a.scope)) {
            return false;
        }
        if (this.matchesNot(this.groupId, a.groupId)) {
            return false;
        }
        if (this.matchesNot(this.artifactId, a.artifactId)) {
            return false;
        }
        if (this.matchesNot(this.type, a.type)) {
            return false;
        }
        return !this.matchesNot(this.classifier, a.classifier);
    }

    private boolean matchesNot(String pattern, String s) {
        return !SelectorUtils.match((String)pattern, (String)s);
    }
}

