/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin.util;

import ch.cmbntr.modulizer.plugin.config.ModuleDependency;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closeables;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.regex.Pattern;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMFactory;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ModuleDescriptors
extends ModuleDependency {
    private static final Pattern MODULE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_](?:[-a-zA-Z0-9_]*[a-zA-Z0-9_])?(?:\\.[a-zA-Z0-9_](?:[-a-zA-Z0-9_]*[a-zA-Z0-9_])?)*");
    private static final Pattern MODULE_SLOT_PATTERN = Pattern.compile("[-a-zA-Z0-9_+*.]+");
    private static final Set<String> SERVICES_DISPOSITION = ImmutableSet.of((Object)"none", (Object)"import", (Object)"export");

    public static ModuleDescriptorBuilder xmlDescriptor(String moduleName, String slot) {
        return new ModuleDescriptorBuilder(moduleName, slot);
    }

    public static boolean isValidModuleName(String name) {
        return MODULE_NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidSlotName(String slot) {
        return MODULE_SLOT_PATTERN.matcher(slot).matches();
    }

    public static boolean isValidServiceDisposition(String services) {
        return SERVICES_DISPOSITION.contains(services);
    }

    public static class ModuleDescriptorBuilder {
        private static final String NAMESPACE = "urn:jboss:module:1.1";
        private final JDOMFactory xml = new DefaultJDOMFactory();
        private final Element root = this.elem("module");
        private final Document doc = this.xml.document(this.root);

        ModuleDescriptorBuilder(String moduleName, String slot) {
            this.setAttr(this.root, "name", true, moduleName);
            this.setAttr(this.root, "slot", slot != null && !"main".equals(slot), slot);
        }

        public ModuleDescriptorBuilder mainClass(String mainClass) {
            if (mainClass != null) {
                this.root.addContent((Content)this.elem("main-class").setAttribute("name", mainClass));
            }
            return this;
        }

        public ModuleDescriptorBuilder resourceRoots(Iterable<String> paths) {
            ImmutableList ps;
            if (paths != null && !(ps = ImmutableList.copyOf(paths)).isEmpty()) {
                Element resources = this.elem("resources");
                for (String path : paths) {
                    resources.addContent((Content)this.elem("resource-root").setAttribute("path", path));
                }
                this.root.addContent((Content)resources);
            }
            return this;
        }

        public ModuleDescriptorBuilder dependencies(Iterable<ModuleDependency> dependencies) {
            ImmutableList deps;
            if (dependencies != null && !(deps = ImmutableList.copyOf(dependencies)).isEmpty()) {
                Element d = this.elem("dependencies");
                for (ModuleDependency dep : deps) {
                    Element m = this.elem("module");
                    this.setAttr(m, "name", true, dep.getName());
                    this.setAttr(m, "slot", dep.getSlot() != null, dep.getSlot());
                    this.setAttr(m, "optional", dep.isOptional(), "true");
                    this.setAttr(m, "export", dep.isExport(), "true");
                    this.setAttr(m, "services", !"none".equals(dep.getServicesDisposition()), dep.getServicesDisposition());
                    d.addContent((Content)m);
                }
                this.root.addContent((Content)d);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ModuleDescriptorBuilder writeTo(File target) throws IOException {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
            try {
                new XMLOutputter(Format.getPrettyFormat()).output(this.doc, (OutputStream)out);
                out.flush();
            }
            finally {
                Closeables.closeQuietly((Closeable)out);
            }
            return this;
        }

        public String toString() {
            return new XMLOutputter(Format.getPrettyFormat()).outputString(this.doc);
        }

        private Element elem(String name) {
            return this.xml.element(name, NAMESPACE);
        }

        private void setAttr(Element e, String name, boolean check, String value) {
            if (check) {
                e.setAttribute(name, value);
            }
        }
    }
}

