/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin.config;

import ch.cmbntr.modulizer.plugin.config.ConfigBase;
import ch.cmbntr.modulizer.plugin.config.ModuleDependency;
import ch.cmbntr.modulizer.plugin.config.ModuleResources;
import ch.cmbntr.modulizer.plugin.util.ModuleDescriptors;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;

public class ModuleSpec
extends ConfigBase {
    private String name;
    private String slot = "main";
    private String mainClass;
    private ModuleResources moduleResources;
    private List<ModuleDependency> dependencies = ImmutableList.of();

    @Override
    public void checkParams() {
        super.checkParams();
        Preconditions.checkState((boolean)ModuleDescriptors.isValidModuleName(this.name), (String)"invalid module name: %s", (Object[])new Object[]{this.name});
        Preconditions.checkState((boolean)ModuleDescriptors.isValidSlotName(this.slot), (String)"invalid slot name: %s", (Object[])new Object[]{this.slot});
        if (this.mainClass != null) {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.mainClass));
        }
        if (this.moduleResources == null) {
            this.moduleResources = new ModuleResources();
        } else {
            this.moduleResources.checkParams();
        }
        for (ModuleDependency dep : this.dependencies) {
            dep.checkParams();
        }
    }

    public ModuleDescriptors.ModuleDescriptorBuilder createDescriptor(Iterable<String> resourceRootPaths) {
        ModuleDescriptors.ModuleDescriptorBuilder desc = ModuleDescriptors.xmlDescriptor(this.name, this.slot);
        desc.mainClass(this.mainClass);
        desc.resourceRoots(resourceRootPaths);
        desc.dependencies(this.dependencies);
        return desc;
    }

    public StringBuilder getDirectoryPath() {
        StringBuilder path = new StringBuilder(40);
        path.append(this.name.replace('.', File.separatorChar));
        path.append(File.separatorChar).append(this.slot);
        path.append(File.separatorChar);
        return path;
    }

    public String getModuleIdentifier() {
        return this.name + ":" + this.slot;
    }

    public Iterable<Artifact> determineModuleArtifacts(Iterable<Artifact> allArtifacts) {
        return Iterables.filter(allArtifacts, this.moduleResources.getArtifactSelector());
    }

    @Override
    protected Objects.ToStringHelper prepareToStringHelper() {
        return super.prepareToStringHelper().add("name", (Object)this.name).add("slot", (Object)this.slot).add("mainClass", (Object)this.mainClass).add("moduleResources", (Object)this.moduleResources).add("dependencies", this.dependencies);
    }
}

