/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin;

import ch.cmbntr.modulizer.modules.ModulizerModulesUtil;
import ch.cmbntr.modulizer.plugin.AbstractModulizeMojo;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.cli.CommandLineUtils;

@Mojo(name="run", requiresProject=false, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ModuleRunnerMojo
extends AbstractModulizeMojo {
    @Parameter(property="args")
    private String commandlineArgs;
    @Parameter(property="wait", defaultValue="true")
    private boolean wait = true;

    @Override
    protected void safeExecute() throws MojoExecutionException, MojoFailureException {
        Object[] args = this.parseCommandlineArgs();
        this.getLog().info((CharSequence)String.format("starting module '%s' (repo=%s, args=%s)", this.mainModule, this.modulesDirectory, Arrays.toString(args)));
        this.invokeLauncher(this.modulesDirectory, this.mainModule, (String[])args);
    }

    private ClassLoader getLauncherLoader() throws MojoExecutionException {
        URL[] urls = new URL[]{this.artifactURL(this.findLauncherPlugin()), this.artifactURL(this.findJBossModules())};
        return new URLClassLoader(urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeLauncher(File repo, String module, String ... args) throws MojoExecutionException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = this.getLauncherLoader();
        ClassLoader origCCL = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            Object[] launchParams = new Object[]{repo, module, args};
            ModuleRunnerMojo.getLaunchMethod(loader, this.wait).invoke(null, launchParams);
        }
        catch (IllegalAccessException e) {
            this.failInvokeLaunchMethod(e.getCause());
        }
        catch (IllegalArgumentException e) {
            this.failInvokeLaunchMethod(e.getCause());
        }
        catch (InvocationTargetException e) {
            this.failInvokeLaunchMethod(e.getCause());
        }
        finally {
            thread.setContextClassLoader(origCCL);
        }
    }

    public static Method getLaunchMethod(ClassLoader loader, boolean wait) throws MojoExecutionException {
        try {
            return ModulizerModulesUtil.getLaunchMethod((ClassLoader)loader, (boolean)wait);
        }
        catch (ClassNotFoundException e) {
            throw ModuleRunnerMojo.failGetLaunchMethod(e);
        }
        catch (NoSuchMethodException e) {
            throw ModuleRunnerMojo.failGetLaunchMethod(e);
        }
        catch (SecurityException e) {
            throw ModuleRunnerMojo.failGetLaunchMethod(e);
        }
    }

    private static MojoExecutionException failGetLaunchMethod(Throwable cause) throws MojoExecutionException {
        throw new MojoExecutionException("could not find launch method", cause);
    }

    private void failInvokeLaunchMethod(Throwable cause) throws MojoExecutionException {
        throw new MojoExecutionException("launch method invocation failed", cause);
    }

    private String[] parseCommandlineArgs() throws MojoExecutionException {
        try {
            return this.commandlineArgs == null ? null : CommandLineUtils.translateCommandline((String)this.commandlineArgs);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

