/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin;

import ch.cmbntr.modulizer.bootstrap.Main;
import ch.cmbntr.modulizer.bootstrap.util.ModulizerIO;
import ch.cmbntr.modulizer.bootstrap.util.Resources;
import ch.cmbntr.modulizer.filetree.Snapshot;
import ch.cmbntr.modulizer.modules.ModulizerModulesUtil;
import ch.cmbntr.modulizer.plugin.AbstractModulizeMojo;
import ch.cmbntr.modulizer.plugin.archiver.ArchiverCallback;
import ch.cmbntr.modulizer.plugin.archiver.ArchiverHelper;
import ch.cmbntr.modulizer.plugin.config.ModuleSpec;
import ch.cmbntr.modulizer.plugin.config.SigningInfo;
import ch.cmbntr.modulizer.plugin.config.Webstart;
import ch.cmbntr.modulizer.plugin.util.ModulizerUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComputationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.jarsigner.JarSigner;
import org.apache.maven.shared.jarsigner.JarSignerException;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerResult;
import org.apache.maven.shared.jarsigner.JarSignerSignRequest;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.jboss.modules.Module;

@Mojo(name="modulize", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class ModulizeMojo
extends AbstractModulizeMojo {
    private static final String RESOURCES_DEF_FRAGMENT_TEMPLATE = "<%%-- resources_def.jspf --%%><%%@ page pageEncoding=\"UTF-8\" %%>\n<%% final java.util.List<String> resources = java.util.Arrays.asList(%s); %%>";
    private static final String WEBSTART_WEB_XML = "WEB-INF/web.xml";
    private static final String WEBSTART_JNLP_TEMPLATE = "template.jnlp";
    private static final String WEBSTART_JNLP_BODY = "WEB-INF/jspf/jnlp/body.jspf";
    private static final String WEBSTART_RESOURCES_DEF_FRAGMENT = "WEB-INF/jspf/jnlp/resources_def.jspf";
    private static final String WEBSTART_RESOURCES_FRAGMENT = "WEB-INF/jspf/jnlp/resources.jspf";
    private static final String WEBSTART_RESOURCE_FRAGMENT = "WEB-INF/jspf/jnlp/resource.jspf";
    private static final List<String> WEBSTART_DEFAULT_FILES = ImmutableList.of((Object)"WEB-INF/web.xml", (Object)"WEB-INF/jspf/jnlp/body.jspf", (Object)"WEB-INF/jspf/jnlp/resources.jspf", (Object)"WEB-INF/jspf/jnlp/resource.jspf", (Object)"WEB-INF/jspf/jnlp/resources_def.jspf");
    @Component
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private ArchiverHelper archiver;
    @Component
    private MavenSession session;
    @Component
    private JarSigner jarSigner;
    @Parameter(defaultValue="false")
    private boolean verbose = false;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter
    private SigningInfo signing;
    @Parameter
    private Webstart webstart;
    @Parameter(defaultValue="launcher", required=true)
    private String launcherClassifierName;
    @Parameter(defaultValue="modules")
    private String modulesClassifierName;
    @Parameter(defaultValue="false")
    private boolean includeModulesInLauncher = false;
    @Parameter(defaultValue="${basedir}/src/main/modules")
    private File overlayDirectory;
    @Parameter
    private Properties bootstrapContext = new Properties();
    @Parameter
    private List<ModuleSpec> modules = ImmutableList.of();
    @Parameter(defaultValue="true")
    private boolean warmupModules = true;
    @Parameter(defaultValue="true")
    private boolean warmupMandatory = true;
    @Parameter(defaultValue="true")
    private boolean stripVersion = true;

    private String conf(String key, String defaultValue) {
        return this.bootstrapContext.getProperty(key, defaultValue);
    }

    private void augmentContext(String msg, Map<String, String> bootstrapInfo) {
        this.log(msg + bootstrapInfo);
        this.bootstrapContext.putAll(bootstrapInfo);
    }

    private List<String> getSpecifiedModuleIdentifiers() {
        ImmutableList.Builder ids = ImmutableList.builder();
        for (ModuleSpec module : this.modules) {
            ids.add((Object)module.getModuleIdentifier());
        }
        return ids.build();
    }

    private String determineLauncherArtifactName() {
        return this.buildArtifactName(this.launcherClassifierName, "jar");
    }

    private String determineModulesArtifactName() {
        return this.buildArtifactName(this.modulesClassifierName, "jar");
    }

    private String determineWebstartArtifactName() {
        return this.buildArtifactName(this.webstart.getClassifierName(), "war");
    }

    private String buildArtifactName(String classifier, String externsion) {
        Artifact artifact = this.project.getArtifact();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        return String.format("%s-%s-%s.%s", artifactId, version, classifier, externsion);
    }

    @Override
    protected void checkParams() {
        super.checkParams();
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.modulesClassifierName), (Object)"invalid classifier");
        HashSet moduleIdentifiers = Sets.newHashSet();
        for (ModuleSpec module : this.modules) {
            String id = module.getModuleIdentifier();
            Preconditions.checkState((boolean)moduleIdentifiers.add(id), (String)"duplicate module identifier: %s", (Object[])new Object[]{id});
            module.checkParams();
        }
        if (this.signing != null) {
            this.signing.checkParams();
        }
        if (this.webstart != null) {
            this.webstart.checkParams();
        }
        this.augmentContext("main module: ", (Map<String, String>)ImmutableMap.of((Object)"modulizer.jboss-modules.main", (Object)this.mainModule, (Object)"modulizer.bootstrap.app.id", (Object)this.conf("modulizer.bootstrap.app.id", this.mainModule)));
    }

    @Override
    protected void safeExecute() throws MojoExecutionException {
        this.createModulesDirectory();
        this.createModules();
        this.copyModulesOverlay();
        this.warmupModules();
        List<File> artifacts = this.createArtifacts();
        this.sign(artifacts);
        this.webstart(artifacts);
    }

    private void createModulesDirectory() throws MojoExecutionException {
        this.log("create modules directory");
        ModulizerUtil.mkdir(this.modulesDirectory);
    }

    private void createModules() throws MojoExecutionException {
        try {
            Map<ModuleSpec, File> lazyModules = ModulizerUtil.computeLazyAsync(this.modules, this.createModule());
            for (Map.Entry<ModuleSpec, File> forcedModule : lazyModules.entrySet()) {
                String id = forcedModule.getKey().getModuleIdentifier();
                File descriptor = forcedModule.getValue();
                this.log(String.format("create module %s -> %s", id, descriptor));
            }
        }
        catch (ComputationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MojoExecutionException) {
                throw (MojoExecutionException)cause;
            }
            throw new MojoExecutionException("create modules failed", cause);
        }
    }

    private Function<ModuleSpec, File> createModule() {
        final Set<Artifact> artifacts = this.collectAllArtifacts();
        return new Function<ModuleSpec, File>(){

            public File apply(ModuleSpec spec) {
                try {
                    File dir = ModulizeMojo.this.createModuleDirectory(spec);
                    Iterable resources = ModulizeMojo.this.copyArtifacts(dir, spec.determineModuleArtifacts(artifacts));
                    return ModulizeMojo.this.createModuleDescriptor(spec, dir, resources);
                }
                catch (MojoExecutionException e) {
                    throw new ComputationException((Throwable)e);
                }
            }
        };
    }

    private synchronized Set<Artifact> collectAllArtifacts() {
        ImmutableSet.Builder allArtifacts = ImmutableSet.builder();
        allArtifacts.add((Object)this.project.getArtifact());
        allArtifacts.addAll((Iterable)this.project.getArtifacts());
        return allArtifacts.build();
    }

    private File createModuleDirectory(ModuleSpec module) throws MojoExecutionException {
        File dir = new File(this.modulesDirectory, module.getDirectoryPath().toString());
        ModulizerUtil.mkdir(dir);
        return dir;
    }

    private Iterable<String> copyArtifacts(File moduleDirectory, Iterable<Artifact> artifacts) throws MojoExecutionException {
        Map<Artifact, File> fromTo = ModulizerUtil.compute(artifacts, this.resourceTargetFile(moduleDirectory));
        final LinkedHashMap targetHashes = ModulizerIO.sha1async(fromTo.values());
        Resources.Pool pool = Resources.getPoolHandle();
        final ExecutorService executor = pool.aquireExec();
        try {
            List<String> list = ModulizerUtil.collect(ImmutableList.copyOf((Collection)Collections2.transform(fromTo.entrySet(), (Function)new Function<Map.Entry<Artifact, File>, Future<String>>(){

                public Future<String> apply(Map.Entry<Artifact, File> e) {
                    Artifact a = e.getKey();
                    File src = a.getFile();
                    File target = e.getValue();
                    Future targetHash = (Future)targetHashes.get(target);
                    Preconditions.checkState((src != null ? 1 : 0) != 0, (String)"missing file for %s", (Object[])new Object[]{a});
                    return executor.submit(ModulizeMojo.this.conditionalCopy(src, target, targetHash));
                }
            })));
            return list;
        }
        catch (ComputationException e) {
            throw new MojoExecutionException("failed to copy artifacts", e.getCause());
        }
        finally {
            pool.releaseExec(executor);
        }
    }

    private Function<Artifact, File> resourceTargetFile(final File moduleDirectory) {
        final boolean removeVersion = this.stripVersion;
        return new Function<Artifact, File>(){

            public File apply(Artifact resource) {
                String version = removeVersion ? "" : "-" + resource.getVersion();
                String classifier = StringUtils.isEmpty((String)resource.getClassifier()) ? "" : "-" + resource.getClassifier();
                String extension = resource.getArtifactHandler().getExtension();
                String name = String.format("%s-%s%s%s.%s", resource.getGroupId(), resource.getArtifactId(), version, classifier, extension);
                return new File(moduleDirectory, name);
            }
        };
    }

    private File createModuleDescriptor(ModuleSpec module, File moduleDirectory, Iterable<String> resources) throws MojoExecutionException {
        try {
            File descriptor = new File(moduleDirectory, "module.xml");
            module.createDescriptor(resources).writeTo(descriptor);
            return descriptor;
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to write module descriptor", (Exception)e);
        }
    }

    private void copyModulesOverlay() throws MojoExecutionException {
        this.copyOverlay("modules", this.overlayDirectory, this.modulesDirectory);
    }

    private void warmupModules() {
        if (this.warmupModules) {
            List<String> ids = this.getSpecifiedModuleIdentifiers();
            for (Module module : ModulizerModulesUtil.tryLoadModules((boolean)this.warmupMandatory, ids, (File[])new File[]{this.modulesDirectory})) {
                this.log("loaded " + module.getIdentifier());
            }
        }
    }

    private File createBundle() throws MojoExecutionException {
        try {
            this.log("create filetree");
            String ref = this.determineBundleRef();
            String bundleName = this.determineBundleName();
            String bundleURI = "/" + bundleName;
            File bundle = new File(this.outputDirectory, bundleName);
            String id = Snapshot.createBundle((File)bundle, (File)this.modulesDirectory, (String)ref);
            this.augmentContext("filetree bootstrap properties: ", (Map<String, String>)ImmutableMap.of((Object)"modulizer.filetree.bundle.id", (Object)id, (Object)"modulizer.filetree.bundle.ref", (Object)ref, (Object)"modulizer.filetree.bundle.uri", (Object)bundleURI));
            return bundle;
        }
        catch (Snapshot.FileTreeSnapshotException e) {
            throw new MojoExecutionException("failed to create bundle", (Exception)((Object)e));
        }
    }

    private String determineBundleName() {
        return new File(this.conf("modulizer.filetree.bundle.uri", "/filetree.dat")).getName().trim();
    }

    private String determineBundleRef() {
        return Snapshot.sanitizeHeadRef((String)this.conf("modulizer.filetree.bundle.ref", "refs/heads/master"));
    }

    private File createBootstrapConfig() throws MojoExecutionException {
        File file;
        File config = new File(this.outputDirectory, "bootstrap-config.xml");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(config);
            this.bootstrapContext.storeToXML(out, null);
            file = config;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("failed to write boostrap-config.xml", (Exception)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(out);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)out);
        return file;
    }

    private List<File> createArtifacts() throws MojoExecutionException {
        List<ArchiverCallback> launcherArtifactContents = this.launcherContents();
        List<ArchiverCallback> modulesArtifactContents = this.modulesContents();
        LinkedList artifacts = Lists.newLinkedList();
        String launcherName = this.determineLauncherArtifactName();
        if (this.includeModulesInLauncher) {
            artifacts.add(this.createArtifact(launcherName, "jar", this.launcherClassifierName, Iterables.concat(launcherArtifactContents, modulesArtifactContents)));
        } else {
            artifacts.add(this.createArtifact(launcherName, "jar", this.launcherClassifierName, launcherArtifactContents));
            artifacts.add(this.createArtifact(this.determineModulesArtifactName(), "jar", this.modulesClassifierName, modulesArtifactContents));
        }
        return artifacts;
    }

    private File createArtifact(String name, String type, String classifier, Iterable<? extends ArchiverCallback> contents) throws MojoExecutionException {
        File target = new File(this.outputDirectory, name);
        this.log("create artifact " + target);
        this.archiver.createArchive(this.session, target, false, contents);
        this.projectHelper.attachArtifact(this.project, type, classifier, target);
        return target;
    }

    private List<ArchiverCallback> launcherContents() throws MojoExecutionException {
        LinkedList contents = Lists.newLinkedList();
        List<Artifact> merges = this.determineLauncherMergeArtifacts();
        this.log("launcher merge: " + merges);
        contents.add(this.archiver.mergeArtifacts(this.outputDirectory, merges));
        Map<File, String> plugins = this.determineLauncherPlugins();
        this.log("launcher plugins: " + plugins);
        contents.add(this.archiver.fileAdder(plugins));
        Map<String, String> entries = this.determineLauncherManifest();
        this.log("launcher manifest: " + entries);
        contents.add(this.archiver.manifest(entries));
        return contents;
    }

    private List<Artifact> determineLauncherMergeArtifacts() {
        return ImmutableList.of((Object)this.findJBossModules(), (Object)this.findModulizerBootstrap());
    }

    private Map<File, String> determineLauncherPlugins() throws MojoExecutionException {
        File prepare = this.findPreparePlugin().getFile();
        String prepareName = ModulizerUtil.sha1Name(prepare);
        File launcher = this.findLauncherPlugin().getFile();
        String launcherName = ModulizerUtil.sha1Name(launcher);
        this.augmentContext("bootstrap plugins: ", (Map<String, String>)ImmutableMap.of((Object)"modulizer.bootstrap.prepare.plugins", (Object)prepareName, (Object)"modulizer.bootstrap.launch.plugins", (Object)launcherName));
        return ImmutableMap.of((Object)prepare, (Object)prepareName, (Object)launcher, (Object)launcherName);
    }

    private Map<String, String> determineLauncherManifest() {
        LinkedHashMap entries = Maps.newLinkedHashMap();
        entries.put("Main-Class", Main.class.getName());
        entries.put("Permissions", "all-permissions");
        entries.put("Codebase", "*");
        if (!this.includeModulesInLauncher) {
            entries.put("Class-Path", this.determineModulesArtifactName());
        }
        return entries;
    }

    private List<ArchiverCallback> modulesContents() throws MojoExecutionException {
        File bundle = this.createBundle();
        File bootstrapConfig = this.createBootstrapConfig();
        return ImmutableList.of((Object)this.archiver.fileAdder(bundle, bootstrapConfig));
    }

    private void sign(Iterable<File> artifacts) throws MojoExecutionException {
        if (this.signing != null) {
            this.log("signing: " + this.signing);
            for (File a : artifacts) {
                JarSignerSignRequest request = this.signing.signRequest(this.outputDirectory, a);
                try {
                    JarSignerResult result = this.jarSigner.execute((JarSignerRequest)request);
                    CommandLineException signException = result.getExecutionException();
                    int signExitCode = result.getExitCode();
                    if (signException != null) {
                        this.failSignature((Exception)signException);
                    }
                    if (signExitCode <= 0) continue;
                    throw new MojoExecutionException("signing returned with exit code: " + signExitCode);
                }
                catch (JarSignerException e) {
                    this.failSignature((Exception)((Object)e));
                }
            }
        }
    }

    private void failSignature(Exception e) throws MojoExecutionException {
        throw new MojoExecutionException("signing failed", e);
    }

    private void webstart(Iterable<File> webstartResources) throws MojoExecutionException {
        if (this.webstart != null) {
            this.log("webstart: " + this.webstart);
            File webstartDir = new File(this.outputDirectory, "webstart");
            ModulizerUtil.mkdir(webstartDir);
            this.copyURLs(this.findWebstartDefaultResources(webstartDir));
            this.copyWebstartResourcesAndCreateDefinitionFragment(webstartDir, webstartResources);
            this.copyOverlay("webstart", this.webstart.getOverlayDirectory(), webstartDir);
            this.createWebstartArtifact(webstartDir);
        }
    }

    private Map<URL, File> findWebstartDefaultResources(File webstartDir) throws MojoExecutionException {
        ImmutableMap.Builder resources = ImmutableMap.builder();
        for (String f : WEBSTART_DEFAULT_FILES) {
            resources.put((Object)this.findWebstartDefaultResource(f), (Object)new File(webstartDir, f));
        }
        File jnlpFile = new File(webstartDir, this.webstart.getJNLPName());
        resources.put((Object)this.findWebstartDefaultResource(WEBSTART_JNLP_TEMPLATE), (Object)jnlpFile);
        return resources.build();
    }

    private URL findWebstartDefaultResource(String file) throws MojoExecutionException {
        URL r = ModulizeMojo.class.getResource("/webstart/" + file);
        if (r == null) {
            throw new MojoExecutionException("could not find webstart default resource: " + file);
        }
        return r;
    }

    private void copyURLs(Map<URL, File> sourcesAndDestinations) throws MojoExecutionException {
        for (Map.Entry<URL, File> srcAndDest : sourcesAndDestinations.entrySet()) {
            URL src = srcAndDest.getKey();
            File dest = srcAndDest.getValue();
            try {
                FileUtils.copyURLToFile((URL)src, (File)dest);
            }
            catch (IOException e) {
                throw new MojoExecutionException("could not copy " + src + " to " + dest, (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyWebstartResourcesAndCreateDefinitionFragment(File webstartDir, Iterable<File> resources) throws MojoExecutionException {
        try {
            String pathPrefix = this.webstart.getResourcesPathPrefix();
            File resourcesDir = new File(webstartDir, pathPrefix);
            LinkedList resourceHREFs = Lists.newLinkedList();
            for (File r : resources) {
                FileUtils.copyFileToDirectory((File)r, (File)resourcesDir);
                resourceHREFs.add(String.format("\"%s/%s\"", pathPrefix, r.getName()));
            }
            Writer w = WriterFactory.newWriter((File)new File(webstartDir, WEBSTART_RESOURCES_DEF_FRAGMENT), (String)"UTF-8");
            try {
                w.write(String.format(RESOURCES_DEF_FRAGMENT_TEMPLATE, Joiner.on((String)", ").join((Iterable)resourceHREFs)));
            }
            finally {
                ModulizerIO.closeQuietly((Closeable)w);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.failCopyWebstartResourcesAndCreateDefinitionFragment(e);
        }
        catch (FileNotFoundException e) {
            this.failCopyWebstartResourcesAndCreateDefinitionFragment(e);
        }
        catch (IOException e) {
            this.failCopyWebstartResourcesAndCreateDefinitionFragment(e);
        }
    }

    private void failCopyWebstartResourcesAndCreateDefinitionFragment(Throwable e) throws MojoExecutionException {
        throw new MojoExecutionException("failed to copy and define webstart resources", e);
    }

    private void createWebstartArtifact(File webstartDir) throws MojoExecutionException {
        ImmutableList warContents = ImmutableList.of((Object)this.archiver.directoryAdder(webstartDir));
        this.createArtifact(this.determineWebstartArtifactName(), "war", this.webstart.getClassifierName(), (Iterable<? extends ArchiverCallback>)warContents);
    }

    private Callable<String> conditionalCopy(final File src, final File target, final Future<String> targetHash) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                String th = (String)targetHash.get();
                if (th == null) {
                    ModulizeMojo.this.copyFile(src, target);
                } else {
                    StringBuilder sourceHash = ModulizerIO.sha1((File)src);
                    if (sourceHash == null) {
                        throw new IllegalArgumentException("source not available " + src);
                    }
                    if (!th.equals(sourceHash.toString())) {
                        ModulizeMojo.this.copyFile(src, target);
                    }
                }
                return target.getName();
            }
        };
    }

    private void copyFile(File src, File dest) throws MojoExecutionException {
        try {
            this.log("copy " + src + " to " + dest);
            FileUtils.copyFile((File)src, (File)dest);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying artifact from " + src + " to " + dest, (Exception)e);
        }
    }

    private void copyOverlay(String displayName, File overlay, File target) throws MojoExecutionException {
        if (overlay != null && overlay.isDirectory()) {
            this.log("copy " + displayName + " overlay from " + overlay);
            try {
                FileUtils.copyDirectoryStructure((File)overlay, (File)target);
                this.removeUnwantedFiles(target);
            }
            catch (IOException e) {
                throw new MojoExecutionException("failed to copy " + overlay.toString(), (Exception)e);
            }
        }
    }

    private void removeUnwantedFiles(File target) throws IOException {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(target);
        ds.setIncludes(FileUtils.getDefaultExcludes());
        ds.scan();
        for (String file : ds.getIncludedFiles()) {
            File f = new File(target, file);
            this.log("delete unwanted " + f);
            boolean deleted = f.delete();
            if (deleted) continue;
            this.log("could not delete " + f);
        }
        for (String dir : ds.getIncludedDirectories()) {
            File d = new File(target, dir);
            this.log("delete unwanted dir " + d);
            FileUtils.deleteDirectory((File)d);
        }
    }

    private void log(CharSequence msg) {
        if (this.verbose) {
            this.getLog().info(msg);
        } else {
            this.getLog().debug(msg);
        }
    }
}

