/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.modulizer.plugin.config;

import ch.cmbntr.modulizer.plugin.config.ConfigBase;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

public class Webstart
extends ConfigBase {
    @Parameter(defaultValue="${basedir}/src/main/webstart")
    private File overlay;
    private String jnlpFile = "launch.jnlp";
    private String resourcesPath = "resources";
    private String classifierName = "webstart";
    private File signFile;
    private File signTemplate;

    @Override
    public void checkParams() {
        super.checkParams();
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.jnlpFile), (Object)"no jnlpFile specified");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.classifierName), (Object)"no classifier specified");
        boolean onlyOne = this.signFile == null || this.signTemplate == null;
        Preconditions.checkState((boolean)onlyOne, (Object)"only one of signFile or signTemplate allowed");
    }

    public String getClassifierName() {
        return this.classifierName;
    }

    public String getJNLPName() {
        return this.jnlpFile;
    }

    public String getResourcesPathPrefix() {
        return this.resourcesPath;
    }

    public File getOverlayDirectory() {
        return this.overlay;
    }

    public Map<File, String> determineSignIncludes() {
        if (this.signFile != null) {
            return ImmutableMap.of((Object)this.signFile, (Object)"JNLP-INF/APPLICATION.JNLP");
        }
        if (this.signTemplate != null) {
            return ImmutableMap.of((Object)this.signTemplate, (Object)"JNLP-INF/APPLICATION_TEMPLATE.JNLP");
        }
        return ImmutableMap.of();
    }

    @Override
    protected Objects.ToStringHelper prepareToStringHelper() {
        return super.prepareToStringHelper().add("jnlpFile", (Object)this.jnlpFile).add("resourcesPath", (Object)this.resourcesPath).add("classifierName", (Object)this.classifierName).add("overlay", (Object)this.overlay).add("signFile", (Object)this.signFile).add("signTemplate", (Object)this.signTemplate);
    }
}

