/*
 * Decompiled with CFR 0.152.
 */
package ch.codexs.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Result<T, I> {
    private final T content;
    private final List<I> issues;

    public static <U, I> Result<U, I> succeeded(U content) {
        return new Result(Objects.requireNonNull(content), List.of());
    }

    @SafeVarargs
    public static <U, I> Result<U, I> succeeded(U content, I firstIssue, I ... issues) {
        return new Result(Objects.requireNonNull(content), Stream.concat(Stream.of(Objects.requireNonNull(firstIssue)), Arrays.stream(issues)).collect(Collectors.toList()));
    }

    public static <U, I> Result<U, I> failed(List<I> issues) {
        if (issues.isEmpty()) {
            throw new IllegalArgumentException("At least one issue is expected");
        }
        return new Result<Object, I>(null, issues);
    }

    @SafeVarargs
    public static <U, I> Result<U, I> failed(I firstIssue, I ... issues) {
        return new Result(null, Stream.concat(Stream.of(Objects.requireNonNull(firstIssue)), Arrays.stream(issues)).collect(Collectors.toList()));
    }

    public static <E extends Throwable> Catcher<E> catching(Class<E> throwableClass) {
        return new Catcher<E>(throwableClass);
    }

    public Result(T content, List<I> issues) {
        this.content = content;
        this.issues = Objects.requireNonNull(issues);
    }

    public boolean hasFailed() {
        return this.content == null;
    }

    public List<I> issues() {
        return this.issues;
    }

    public <U> Result<U, I> map(Function<T, U> mapper) {
        return this.content == null ? new Result<Object, I>(null, this.issues) : new Result<U, I>(mapper.apply(this.content), this.issues);
    }

    public <U> Result<U, I> flatMap(Function<T, Result<U, I>> mapper) {
        if (this.content == null) {
            return Result.failed(this.issues);
        }
        Result<U, I> mappingResult = mapper.apply(this.content);
        return new Result<T, I>(mappingResult.content, Result.concatIssues(this.issues, mappingResult.issues));
    }

    public <J> Result<T, J> mapIssues(Function<I, J> mapper) {
        return new Result(this.content, this.issues.stream().map(mapper).collect(Collectors.toList()));
    }

    public <U, J> Result<U, J> mapBoth(Function<T, U> contentMapper, Function<I, J> issueMapper) {
        List mappedIssues = this.issues.stream().map(issueMapper).collect(Collectors.toList());
        if (this.content != null) {
            return new Result(contentMapper.apply(this.content), mappedIssues);
        }
        return new Result(null, mappedIssues);
    }

    @SafeVarargs
    public final Result<T, I> withAddedIssues(Iterable<I> ... issueLists) {
        return new Result<T, I>(this.content, Result.concatIssues(this.issues, issueLists));
    }

    private Result<T, I> withPrependedIssues(List<I> issueLists) {
        return new Result<T, I>(this.content, Result.concatIssues(issueLists, this.issues));
    }

    @SafeVarargs
    public final Result<T, I> withAddedIssues(I ... issues) {
        return new Result(this.content, Stream.concat(this.issues.stream(), Arrays.stream(issues)).collect(Collectors.toList()));
    }

    @SafeVarargs
    private static <I> List<I> concatIssues(List<I> issues, Iterable<I> ... issueLists) {
        return Stream.concat(issues.stream(), Stream.of(issueLists).flatMap((? super T iterable) -> StreamSupport.stream(iterable.spliterator(), false))).collect(Collectors.toList());
    }

    public ThenValueProcessor ifIssuesExistDo(Consumer<List<I>> issueConsumer) {
        if (!this.issues.isEmpty()) {
            issueConsumer.accept(this.issues);
        }
        return new ThenValueProcessor();
    }

    public ElseValueProcessor ifFailedDo(Consumer<List<I>> issueConsumer) {
        if (this.hasFailed()) {
            issueConsumer.accept(this.issues);
        }
        return new ElseValueProcessor();
    }

    public <R> ValueTransformer<R> ifFailedTransform(Function<List<I>, R> issueTransformer) {
        Object valueOutOfIssues = this.hasFailed() ? (Object)issueTransformer.apply(this.issues) : null;
        return new ValueTransformer<Object>(valueOutOfIssues);
    }

    public <U> IssueTransformer<U, I> unwrap(BiFunction<T, List<I>, U> mapper) {
        if (!this.hasFailed()) {
            return new IssueTransformer<U, I>(mapper.apply(this.content, this.issues), this.issues);
        }
        return new IssueTransformer<Object, I>(null, this.issues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return Objects.equals(this.content, result.content) && Objects.equals(this.issues, result.issues);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.issues);
    }

    public <U> BiCombiner<U> combineWith(Result<U, I> other) {
        return new BiCombiner<U>(other);
    }

    public static <T, I> Result<List<T>, I> combineAllSuccessful(Collection<Result<T, I>> results) {
        List issues = results.stream().flatMap((? super T r) -> r.issues.stream()).collect(Collectors.toList());
        List values = results.stream().filter(result -> !result.hasFailed()).flatMap((? super T result) -> Stream.ofNullable(result.content)).collect(Collectors.toList());
        return new Result(values, issues);
    }

    public static class IssueTransformer<T, I> {
        private final T upstreamValue;
        private final List<I> issues;

        IssueTransformer(T upstreamValue, List<I> issues) {
            this.upstreamValue = upstreamValue;
            this.issues = issues;
        }

        public T orElse(Function<List<I>, T> issueTransformation) {
            if (this.upstreamValue != null) {
                return this.upstreamValue;
            }
            return issueTransformation.apply(this.issues);
        }
    }

    public class ElseValueProcessor
    extends ValueProcessor {
        public T elseGetContent() {
            return Result.this.content;
        }
    }

    public class ThenValueProcessor
    extends ValueProcessor {
        public T thenGetContent() {
            return Result.this.content;
        }
    }

    public abstract class ValueProcessor {
        public void ifSucceededDo(Consumer<T> valueConsumer) {
            if (Result.this.content != null) {
                valueConsumer.accept(Result.this.content);
            }
        }

        public void ifSucceededDo(BiConsumer<T, List<I>> valueConsumer) {
            if (Result.this.content != null) {
                valueConsumer.accept(Result.this.content, Result.this.issues);
            }
        }
    }

    public final class BiCombiner<U> {
        private final Result<U, I> other;

        BiCombiner(Result<U, I> other) {
            this.other = other;
        }

        public <V> Result<V, I> mergeMap(BiFunction<T, U, V> combiner) {
            List concatenatedIssues = Stream.concat(Result.this.issues.stream(), this.other.issues.stream()).collect(Collectors.toList());
            if (Result.this.content == null || this.other.hasFailed()) {
                return Result.failed(concatenatedIssues);
            }
            return new Result(combiner.apply(Result.this.content, this.other.content), concatenatedIssues);
        }

        public <V> Result<V, I> mergeFlatMap(BiFunction<T, U, Result<V, I>> combiner) {
            List concatenatedIssues = Stream.concat(Result.this.issues.stream(), this.other.issues.stream()).collect(Collectors.toList());
            if (Result.this.content == null || this.other.hasFailed()) {
                return Result.failed(concatenatedIssues);
            }
            return combiner.apply(Result.this.content, this.other.content).withPrependedIssues(concatenatedIssues);
        }
    }

    public class ValueTransformer<R> {
        R upstreamValue;

        ValueTransformer(R upstreamValue) {
            this.upstreamValue = upstreamValue;
        }

        public R orElseUnwrap(BiFunction<T, List<I>, R> valuetransformer) {
            return (R)Optional.ofNullable(this.upstreamValue).orElseGet(() -> valuetransformer.apply(Result.this.content, Result.this.issues));
        }
    }

    public static class Catcher<E extends Throwable> {
        private final Class<E> throwableClass;

        Catcher(Class<E> throwableClass) {
            this.throwableClass = throwableClass;
        }

        public <T> Result<T, E> run(ThrowingSupplier<T, E> supplier) {
            try {
                return Result.succeeded(supplier.supply());
            }
            catch (Throwable exception) {
                if (this.throwableClass.isAssignableFrom(this.throwableClass)) {
                    return Result.failed((Throwable)this.throwableClass.cast(exception), new Throwable[0]);
                }
                throw new RuntimeException(exception);
            }
        }
    }

    public static interface ThrowingSupplier<T, E extends Throwable> {
        public T supply() throws E;
    }
}

