/*
 * Decompiled with CFR 0.152.
 */
package ch.dkitc.ridioc;

import ch.dkitc.ridioc.DIMethods;
import ch.dkitc.ridioc.DIObjectFactoryInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public final class DI {
    public static <FACTORY> FACTORY createObjectFactory(Class<FACTORY> factoryType, String packagePrefix) {
        String realPackagePrefix = DI.checkAndMassagePackagePrefix(packagePrefix);
        Class<FACTORY> checkedFactoryType = DI.checkFactoryType(factoryType);
        DIObjectFactoryInvocationHandler factoryHandler = new DIObjectFactoryInvocationHandler(realPackagePrefix, DI.createWrappedPrimitiveTypeMap());
        return (FACTORY)Proxy.newProxyInstance(factoryType.getClassLoader(), new Class[]{checkedFactoryType}, (InvocationHandler)factoryHandler);
    }

    public static Map<Class<?>, Class<?>> createWrappedPrimitiveTypeMap() {
        HashMap wrappedPrimitiveTypeMap = new HashMap();
        wrappedPrimitiveTypeMap.put(Byte.TYPE, Byte.class);
        wrappedPrimitiveTypeMap.put(Short.TYPE, Short.class);
        wrappedPrimitiveTypeMap.put(Integer.TYPE, Integer.class);
        wrappedPrimitiveTypeMap.put(Long.TYPE, Long.class);
        wrappedPrimitiveTypeMap.put(Float.TYPE, Float.class);
        wrappedPrimitiveTypeMap.put(Double.TYPE, Double.class);
        wrappedPrimitiveTypeMap.put(Character.TYPE, Character.class);
        wrappedPrimitiveTypeMap.put(Boolean.TYPE, Boolean.class);
        return wrappedPrimitiveTypeMap;
    }

    public static <FACTORY> Class<FACTORY> checkFactoryType(Class<FACTORY> factoryType) {
        if (factoryType == null) {
            throw new IllegalArgumentException("'factoryType' must not be NULL");
        }
        DIMethods methods = new DIMethods(factoryType).mustNotBeAnInterface().mustHaveNumberOfMethods(5);
        methods.mustContainExactlyOneMethod("newInstance").mustHaveParametersOfType(Class.class, Object[].class).mustHaveReturnType(Object.class);
        methods.mustContainExactlyOneMethod("instance").mustHaveParametersOfType(Class.class).mustHaveReturnType(Object.class);
        methods.mustContainExactlyOneMethod("registerInstance").mustHaveParametersOfType(Class.class, Object.class).mustHaveReturnType(Object.class);
        methods.mustContainExactlyOneMethod("registerStringLiteral").mustHaveParametersOfType(String.class, String.class).mustHaveReturnType(String.class);
        methods.mustContainExactlyOneMethod("registerStringLiteralArray").mustHaveParametersOfType(String.class, String[].class).mustHaveReturnType(String[].class);
        return factoryType;
    }

    private static String checkAndMassagePackagePrefix(String packagePrefix) {
        if (packagePrefix == null || packagePrefix.isEmpty()) {
            throw new IllegalArgumentException("'packagePrefix' must not be NULL or empty");
        }
        String realPackagePrefix = packagePrefix.endsWith(".") ? packagePrefix.substring(0, packagePrefix.length() - 1) : packagePrefix;
        return realPackagePrefix;
    }
}

