/*
 * Decompiled with CFR 0.152.
 */
package ch.dkitc.ridioc;

import ch.dkitc.ridioc.DIConstructor;
import ch.dkitc.ridioc.DIListUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DIConstructors
extends ArrayList<DIConstructor> {
    private final Class<?> type;

    public DIConstructors(Class<?> type, Map<Class<?>, Class<?>> wrappedPrimitiveTypeMap) {
        this.type = type;
        for (Constructor<?> constructor : type.getConstructors()) {
            this.add(new DIConstructor(constructor, wrappedPrimitiveTypeMap));
        }
    }

    public DIConstructors mustHaveAtLeastOnePublicConstructor() {
        if (this.size() <= 0) {
            throw new IllegalArgumentException(this.type + ": There must be at least ONE public constructor");
        }
        return this;
    }

    public List<DIConstructor> findMatchingConstructorsByParams(Object ... params) {
        this.mustHaveAtLeastOnePublicConstructor();
        DIConstructor diConstructor = this.findMatchingConstructorByParams(params);
        if (diConstructor != null) {
            return DIListUtils.toList(diConstructor);
        }
        DIConstructor diDefaultConstructor = this.findDefaultConstructor();
        if (diDefaultConstructor != null) {
            return DIListUtils.toList(diDefaultConstructor);
        }
        return this;
    }

    public DIConstructor findMatchingConstructorByParams(Object ... params) {
        for (DIConstructor diConstructor : this) {
            if (!diConstructor.matchesParams(params)) continue;
            return diConstructor;
        }
        return null;
    }

    public DIConstructor findMatchingConstructorByParamTypes(Class<?> ... paramTypes) {
        for (DIConstructor diConstructor : this) {
            if (!diConstructor.matchesParamTypes(paramTypes)) continue;
            return diConstructor;
        }
        return null;
    }

    public DIConstructor findDefaultConstructor() {
        return this.findMatchingConstructorByParams(new Object[0]);
    }
}

