/*
 * Decompiled with CFR 0.152.
 */
package ch.dkitc.ridioc;

import ch.dkitc.ridioc.DIAggregateException;
import ch.dkitc.ridioc.DIConstructor;
import ch.dkitc.ridioc.DIConstructorParam;
import ch.dkitc.ridioc.DIConstructorParams;
import ch.dkitc.ridioc.DIConstructors;
import ch.dkitc.ridioc.DIInstanceMethodParam;
import ch.dkitc.ridioc.DIInstanceMethodParams;
import ch.dkitc.ridioc.DIMethodParamsIndex;
import ch.dkitc.ridioc.DIParamUtils;
import ch.dkitc.ridioc.DIReflectionsCache;
import ch.dkitc.ridioc.DIStringLiteralStore;
import ch.dkitc.ridioc.DITypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DIObjectFactoryHelper {
    private final Map<Class<?>, Object> instanceCache = new HashMap();
    private final DIReflectionsCache reflectionsCache;
    private final Map<Class<?>, Class<?>> wrappedPrimitiveTypeMap;
    private final DIStringLiteralStore stringLiteralStore;

    public DIObjectFactoryHelper(String packagePrefix, Map<Class<?>, Class<?>> wrappedPrimitiveTypeMap) {
        this.reflectionsCache = new DIReflectionsCache(packagePrefix);
        this.wrappedPrimitiveTypeMap = wrappedPrimitiveTypeMap;
        this.stringLiteralStore = new DIStringLiteralStore(wrappedPrimitiveTypeMap);
    }

    public <T> T newInstance(Class<T> type, Object ... params) {
        DITypeUtils.checkType(type);
        DIParamUtils.checkParams(params);
        Class<T> potentialImplType = this.getSinglePotentialImplType(type);
        return this.constructOneImplementation(type, potentialImplType, params);
    }

    public Object instance(Class<?> type) throws IllegalArgumentException {
        DITypeUtils.checkType(type);
        if (this.instanceCache.containsKey(type)) {
            return this.instanceCache.get(type);
        }
        Class<?> potentialImplType = this.getSinglePotentialImplType(type);
        Object instance = this.constructOneImplementation(type, potentialImplType, new Object[0]);
        this.instanceCache.put(type, instance);
        return instance;
    }

    public String registerStringLiteral(String key, String singleValue) {
        return this.stringLiteralStore.putSingleValue(key, singleValue);
    }

    public String[] registerStringLiteralArray(String key, String[] arrayValue) {
        return this.stringLiteralStore.putArrayValue(key, arrayValue);
    }

    public Object registerInstance(Class<?> type, Object instance) {
        Class<?> realType = type.isPrimitive() ? this.getWrappedPrimitiveType(type) : type;
        return this.instanceCache.put(realType, instance);
    }

    private <T> T constructOneImplementation(Class<T> type, Class<?> potentialImplType, Object ... params) {
        List<DIConstructor> diConstructors = new DIConstructors(potentialImplType, this.wrappedPrimitiveTypeMap).findMatchingConstructorsByParams(params);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (DIConstructor diConstructor : diConstructors) {
            DIConstructorParams constructorParams = this.createConstructorParams(diConstructor);
            DIInstanceMethodParams instanceMethodParams = new DIInstanceMethodParams(params);
            try {
                return this.newInstance(diConstructor, constructorParams, instanceMethodParams);
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        throw new DIAggregateException("Cound not instantiate implementation for type '" + type + "'", exceptions);
    }

    private Object createArrayInitArg(Class<?> constructorParamType) {
        ArrayList subTypeImplementations = new ArrayList();
        Class<?> paramArrayComponentType = constructorParamType.getComponentType();
        for (Class<?> subTypeImpl : this.reflectionsCache.getSubTypesOf(paramArrayComponentType)) {
            if (Modifier.isAbstract(subTypeImpl.getModifiers()) || !DITypeUtils.hasDefaultConstructor(subTypeImpl)) continue;
            subTypeImplementations.add(this.constructOneImplementation(paramArrayComponentType, subTypeImpl, new Object[0]));
        }
        return subTypeImplementations.toArray((Object[])Array.newInstance(paramArrayComponentType, subTypeImplementations.size()));
    }

    private DIConstructorParams createConstructorParams(DIConstructor diConstructor) {
        List<String> paramNames = diConstructor.getParameterNames();
        DIConstructorParams constructorParams = new DIConstructorParams();
        for (int i = 0; i < paramNames.size(); ++i) {
            constructorParams.add(paramNames.get(i), diConstructor.getParamType(i), diConstructor.getParamAnnotations(i));
        }
        return constructorParams;
    }

    private <T> List<Class<? extends T>> getPotentialImplTypes(Class<T> type) {
        Set<Class<T>> types = this.reflectionsCache.getSubTypesOf(type);
        ArrayList<Class<T>> potentialImplTypes = new ArrayList<Class<T>>();
        Iterator<Class<T>> it = types.iterator();
        while (it.hasNext()) {
            Class<T> potentialImplType = it.next();
            if (Modifier.isAbstract(potentialImplType.getModifiers())) {
                it.remove();
                continue;
            }
            potentialImplTypes.add(potentialImplType);
        }
        return potentialImplTypes;
    }

    private <T> Class<? extends T> getSinglePotentialImplType(Class<T> type) throws IllegalArgumentException {
        List<Class<T>> potentialImplTypes = this.getPotentialImplTypes(type);
        switch (potentialImplTypes.size()) {
            case 0: {
                throw new IllegalArgumentException("no matching implementation of type " + type + "' found within '" + this.reflectionsCache.getUrls() + '\"');
            }
            case 1: {
                return potentialImplTypes.get(0);
            }
        }
        throw new IllegalArgumentException(potentialImplTypes.size() + " matching implementation types found within '" + this.reflectionsCache.getUrls() + '\"');
    }

    private Class<?> getWrappedPrimitiveType(Class<?> type) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("Given type '" + type + " is NOT primitive");
        }
        if (!this.wrappedPrimitiveTypeMap.containsKey(type)) {
            throw new IllegalArgumentException("There is no wrapped type for primitive type '" + type + "' available");
        }
        return this.wrappedPrimitiveTypeMap.get(type);
    }

    private <T> T newInstance(DIConstructor diConstructor, DIConstructorParams constructorParams, DIInstanceMethodParams instanceMethodParams) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        ArrayList<Object> initArgsAsList = new ArrayList<Object>();
        HashMap methodParamsIndexMap = new HashMap();
        int usedMethodParamCount = 0;
        for (DIConstructorParam constrParam : constructorParams) {
            DIInstanceMethodParam instanceMethodParamOfType;
            DIMethodParamsIndex methodParamsIndex;
            Class<?> constrParamType = constrParam.getType();
            if (Collection.class.isAssignableFrom(constrParamType)) {
                throw new IllegalArgumentException("Collections are NOT supported - I cannot determine the element type at runtime: http://stackoverflow.com/questions/10945993/using-java-reflections-to-find-collections-element-type");
            }
            if (constrParamType.isPrimitive()) {
                constrParamType = this.getWrappedPrimitiveType(constrParamType);
            }
            if ((methodParamsIndex = (DIMethodParamsIndex)methodParamsIndexMap.get(constrParamType)) == null) {
                DIInstanceMethodParams methodParamsOfType = instanceMethodParams.getParamsOfType(constrParamType);
                methodParamsIndex = new DIMethodParamsIndex(methodParamsOfType);
                methodParamsIndexMap.put(constrParamType, methodParamsIndex);
            }
            if ((instanceMethodParamOfType = methodParamsIndex.next()) != null) {
                initArgsAsList.add(instanceMethodParamOfType.getValue());
                ++usedMethodParamCount;
                continue;
            }
            if (constrParam.isArray()) {
                if (constrParam.isArrayOfNumbers()) {
                    throw new IllegalArgumentException(constrParam + ": Array of primitives not (yet) supported");
                }
                if (constrParam.isArrayOfPrimitives()) {
                    throw new IllegalArgumentException(constrParam + ": Array of primitives not (yet) supported");
                }
                if (constrParam.isArrayOfEnums()) {
                    throw new IllegalArgumentException(constrParam + ": Array of enums are not (yet) supported");
                }
                if (constrParam.isArrayOfStrings()) {
                    initArgsAsList.add(this.stringLiteralStore.getArrayValue(constrParam.getName()));
                    continue;
                }
                if (constrParam.isArrayOfDates()) {
                    throw new IllegalArgumentException(constrParam + ": Array of dates are not (yet) supported");
                }
                if (constrParam.isArrayOfArrays()) {
                    throw new IllegalArgumentException(constrParam + ": Array of arrays not (yet) supported");
                }
                initArgsAsList.add(this.createArrayInitArg(constrParamType));
                continue;
            }
            if (constrParam.isNumber() || constrParam.isPrimitive() || constrParam.isEnum() || constrParam.isString() || constrParam.isDate() || constrParam.isCharacter() || constrParam.isBoolean()) {
                if (this.instanceCache.containsKey(constrParamType)) {
                    initArgsAsList.add(this.instanceCache.get(constrParamType));
                    continue;
                }
                if (this.stringLiteralStore.containsSingleValue(constrParam.getName())) {
                    initArgsAsList.add(this.stringLiteralStore.convertSingleValueTo(constrParam.getName(), constrParamType));
                    continue;
                }
                throw new IllegalArgumentException("Could not find " + constrParam.getName() + " of type " + constrParamType + " within instance cache or string literal store");
            }
            initArgsAsList.add(this.instance(constrParamType));
        }
        if (initArgsAsList.size() != constructorParams.size()) {
            throw new IllegalArgumentException("There should be " + constructorParams.size() + " arguments, but there are " + initArgsAsList.size() + " arguments");
        }
        if (usedMethodParamCount != instanceMethodParams.size()) {
            throw new IllegalArgumentException("Only " + usedMethodParamCount + " out of " + instanceMethodParams.size() + " params have been used");
        }
        return diConstructor.newInstance(initArgsAsList);
    }
}

