/*
 * Decompiled with CFR 0.152.
 */
package ch.dkitc.ridioc;

import ch.dkitc.ridioc.DIObjectFactoryHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class DIObjectFactoryInvocationHandler
implements InvocationHandler {
    private final DIObjectFactoryHelper objectFactoryHelper;
    private final Map<String, ObjectFactoryMethodHandler> objectFactoryMethodHandlerMap = new HashMap<String, ObjectFactoryMethodHandler>();

    protected DIObjectFactoryInvocationHandler(String packagePrefix, Map<Class<?>, Class<?>> wrappedPrimitiveTypeMap) {
        this.objectFactoryHelper = new DIObjectFactoryHelper(packagePrefix, wrappedPrimitiveTypeMap);
        this.objectFactoryMethodHandlerMap.put("newInstance", new ObjectFactoryMethodHandler(){

            @Override
            public Object invoke(Method method, Object[] args) {
                if (args.length <= 0) {
                    throw new IllegalArgumentException("There should be at least ONE parameter of type 'Class<?>'");
                }
                Class type = (Class)DIObjectFactoryInvocationHandler.this.castTo(args[0], Class.class);
                Object[] params = (Object[])DIObjectFactoryInvocationHandler.this.castTo(args[1], Object[].class);
                return DIObjectFactoryInvocationHandler.this.objectFactoryHelper.newInstance(type, params);
            }
        });
        this.objectFactoryMethodHandlerMap.put("instance", new ObjectFactoryMethodHandler(){

            @Override
            public Object invoke(Method method, Object[] args) {
                if (args.length != 1) {
                    throw new IllegalArgumentException("There should be EXACTLY ONE parameter of type 'Class<?>'");
                }
                Class type = (Class)DIObjectFactoryInvocationHandler.this.castTo(args[0], Class.class);
                if (type.getClass().isInstance(this)) {
                    return DIObjectFactoryInvocationHandler.this.castTo(this, type);
                }
                return DIObjectFactoryInvocationHandler.this.objectFactoryHelper.instance(type);
            }
        });
        this.objectFactoryMethodHandlerMap.put("registerStringLiteral", new ObjectFactoryMethodHandler(){

            @Override
            public Object invoke(Method method, Object[] args) {
                if (args.length != 2) {
                    throw new IllegalArgumentException("There should be at EXACTLY TWO parameters of type 'java.lang.String'");
                }
                return DIObjectFactoryInvocationHandler.this.objectFactoryHelper.registerStringLiteral((String)DIObjectFactoryInvocationHandler.this.castTo(args[0], String.class), (String)DIObjectFactoryInvocationHandler.this.castTo(args[1], String.class));
            }
        });
        this.objectFactoryMethodHandlerMap.put("registerStringLiteralArray", new ObjectFactoryMethodHandler(){

            @Override
            public Object invoke(Method method, Object[] args) {
                DIObjectFactoryInvocationHandler.argumentsMustHaveExactArgumentsCountOf(args, 2);
                return DIObjectFactoryInvocationHandler.this.objectFactoryHelper.registerStringLiteralArray((String)DIObjectFactoryInvocationHandler.this.castTo(args[0], String.class), (String[])DIObjectFactoryInvocationHandler.this.castTo(args[1], String[].class));
            }
        });
        this.objectFactoryMethodHandlerMap.put("registerInstance", new ObjectFactoryMethodHandler(){

            @Override
            public Object invoke(Method method, Object[] args) {
                DIObjectFactoryInvocationHandler.argumentsMustHaveExactArgumentsCountOf(args, 2);
                Class type = (Class)DIObjectFactoryInvocationHandler.this.castTo(args[0], Class.class);
                Object instance = args[1];
                return DIObjectFactoryInvocationHandler.this.objectFactoryHelper.registerInstance(type, instance);
            }
        });
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) {
        ObjectFactoryMethodHandler methodHandler = this.objectFactoryMethodHandlerMap.get(method.getName());
        if (methodHandler == null) {
            throw new IllegalArgumentException("Cannot handle method '" + method.getName() + "'");
        }
        return methodHandler.invoke(method, args);
    }

    private <T> T castTo(Object arg, Class<T> type) {
        if (type.isInstance(arg)) {
            return (T)arg;
        }
        throw new ClassCastException("Cannot cast value " + arg.getClass().getName() + " to type " + type.getName());
    }

    private static void argumentsMustHaveExactArgumentsCountOf(Object[] args, int count) {
        if (args.length != count) {
            throw new IllegalArgumentException("There should be at EXACTLY " + count + " parameters, but there are " + args.length);
        }
    }

    public static interface ObjectFactoryMethodHandler {
        public Object invoke(Method var1, Object[] var2);
    }
}

