/*
 * Decompiled with CFR 0.152.
 */
package ch.dkitc.ridioc;

import ch.dkitc.ridioc.DIConstructor;
import ch.dkitc.ridioc.DIConstructors;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class DIStringLiteralStore {
    private final Map<String, String> singleValueMap = new HashMap<String, String>();
    private final Map<String, String[]> arrayValueMap = new HashMap<String, String[]>();
    private final Map<Class<?>, Class<?>> wrappedPrimitiveTypeMap;

    public DIStringLiteralStore(Map<Class<?>, Class<?>> wrappedPrimitiveTypeMap) {
        this.wrappedPrimitiveTypeMap = wrappedPrimitiveTypeMap;
    }

    public Object convertSingleValueTo(String name, Class<?> type) {
        String value = this.mustBeInSingleValueMap(name);
        if (Number.class.isAssignableFrom(type)) {
            DIConstructor diConstructor = new DIConstructors(type, this.wrappedPrimitiveTypeMap).findMatchingConstructorByParamTypes(String.class);
            if (diConstructor == null) {
                throw new IllegalArgumentException(type + " does not have constructor that takes a single string argument");
            }
            try {
                return diConstructor.newInstance(value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot convert '" + name + "'='" + value + "' to type '" + type.getName() + "'", ex);
            }
        }
        if (type.isPrimitive()) {
            Class<?> wrappedType = this.wrappedPrimitiveTypeMap.get(type);
            if (wrappedType == null) {
                throw new IllegalArgumentException("Cannot convert '" + name + "'='" + value + "' to primitive type '" + type.getName() + "' no wrapped type found");
            }
            try {
                return wrappedType.getMethod("valueOf", String.class).invoke(null, value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot convert '" + name + "'='" + value + "' to primitive type '" + type.getName() + "' with wrapped type '" + wrappedType + "'", ex);
            }
        }
        if (type.isEnum()) {
            try {
                return type.getMethod("valueOf", Class.class, String.class).invoke(null, type, value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot convert '" + name + "'='" + value + "' to enum type '" + type.getName() + "'", ex);
            }
        }
        if (String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return DatatypeConverter.parseDateTime((String)value).getTime();
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return Boolean.valueOf(value);
        }
        if (Character.class.isAssignableFrom(type)) {
            if (!value.startsWith("\\u")) {
                throw new IllegalArgumentException("Unicode character must start with '\\u' but looks like this: '" + value + "'");
            }
            String unicode = value.substring(2);
            return Character.valueOf((char)Integer.parseInt(unicode, 16));
        }
        throw new IllegalArgumentException(type + " is not supported");
    }

    public boolean containsSingleValue(String name) {
        return this.singleValueMap.containsKey(name);
    }

    public String putSingleValue(String name, String singleValue) {
        return this.singleValueMap.put(name, singleValue);
    }

    public String[] getArrayValue(String name) {
        return this.mustBeInArrayValueMap(name);
    }

    public String[] putArrayValue(String name, String[] arrayValue) {
        return this.arrayValueMap.put(name, arrayValue);
    }

    private String mustBeInSingleValueMap(String name) {
        if (!this.singleValueMap.containsKey(name)) {
            throw new IllegalArgumentException("String literal Store does not contain single value for name '" + name + "'");
        }
        return this.singleValueMap.get(name);
    }

    private String[] mustBeInArrayValueMap(String name) {
        if (!this.arrayValueMap.containsKey(name)) {
            throw new IllegalArgumentException("String literal store does not contain array value for name '" + name + "'");
        }
        return this.arrayValueMap.get(name);
    }
}

