package ch.vd.shared.iam.core.filter.auth;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;
import java.util.Date;
import java.util.List;

public abstract class AbstractIamAuthentication extends AbstractAuthenticationToken {

    public AbstractIamAuthentication(Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
    }

    @Override
    public Object getCredentials() {
        // Il n'y a pas de credentials (password) avec IAM
        return "";
    }

    public abstract String getApplication();

    public abstract String getIUP();

    public abstract String getFirstname();

    public abstract String getLastname();

    public abstract String getEmail();

    public abstract Integer getAuthLevel();

    public abstract Date getLastLoginTime();

    public abstract Collection<IamAuthority> getAllRoles();

    public abstract List<String> getIamOriginalRoles();

    /**
     * @return true si authLevel == 20
     */
    public boolean isStrongAuth() {
        return getAuthLevel() != null && (getAuthLevel() == 20);
    }
}
