package ch.vd.shared.iam.core.filter.auth;

import org.springframework.security.core.GrantedAuthority;

public class IamAuthority implements GrantedAuthority {

    private static final long serialVersionUID = 1L;

    private final String role;

    public IamAuthority(String role) {
        this.role = role;
    }

    @Override
    public String getAuthority() {
        return role;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return obj.equals(role);
        }

        if (obj instanceof GrantedAuthority) {
            GrantedAuthority attr = (GrantedAuthority) obj;

            return role.equals(attr.getAuthority());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return role.hashCode();
    }

    @Override
    public String toString() {
        return role;
    }
}
