package ch.vd.shared.iam.core.util;

import ch.vd.shared.iam.core.filter.auth.IamAuthentication;
import ch.vd.shared.iam.core.filter.auth.IamAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class IamHolder {

    private static IamAuthentication getAuthentication() {
        return (IamAuthentication) SecurityContextHolder.getContext().getAuthentication();
    }

    public static String getApplication() {
        IamAuthentication authentication = getAuthentication();
        return authentication != null ? authentication.getApplication() : null;
    }

    public static Object getPrincipal() {
        IamAuthentication authentication = getAuthentication();
        return authentication != null ? authentication.getPrincipal() : null;
    }

    public static String getUsername() {
        IamAuthentication authentication = getAuthentication();
        return authentication != null ? authentication.getUsername() : null;
    }

    public static String getFirstname() {
        IamAuthentication authentication = getAuthentication();
        return authentication != null ? authentication.getFirstname() : null;
    }

    public static String getLastname() {
        IamAuthentication authentication = getAuthentication();
        return authentication != null ? authentication.getLastname() : null;
    }

    public static String getEmail() {
        IamAuthentication authentication = getAuthentication();
        return authentication != null ? authentication.getEmail() : null;
    }

    public static Integer getAuthLevel() {
        IamAuthentication authentication = getAuthentication();
        return authentication != null ? authentication.getAuthLevel() : null;
    }

    public static Date getLastLoginTime() {
        IamAuthentication authentication = getAuthentication();
        return authentication != null ? authentication.getLastLoginTime() : null;
    }

    public static List<String> getIamOriginalRoles() {
        IamAuthentication authentication = getAuthentication();
        return authentication != null ? authentication.getIamOriginalRoles() : new ArrayList<>();
    }

    public static Collection<IamAuthority> getAllRoles() {
        IamAuthentication authentication = getAuthentication();
        return authentication != null ? authentication.getAllRoles() : new ArrayList<>();
    }

    public static boolean isStrongAuth() {
        IamAuthentication authentication = getAuthentication();
        return authentication != null && authentication.isStrongAuth();
    }

    public static boolean hasRole(String auth) {
        IamAuthentication authentication = getAuthentication();
        return authentication != null
                && authentication.getAuthorities().stream().anyMatch(au -> au.getAuthority().equals(auth));
    }
}
