package ch.vd.shared.iam.web.filter.auth;

import ch.vd.shared.iam.core.filter.auth.AbstractIamDetails;

/**
 * Permet de rajouter des informations de session lors de la connection
 * Permet également de "augmenter" les roles basés sur une hierarchie:
 * ADMIN est aussi SECRETAIRE qui est aussi USER
 * SECRETAIRE est aussi USER
 * etc ...
 */
public interface AdditionalInformationProvider {

    /**
     * @param authenticateProvider l'objet représentant les propriétés sécurité de l'utilisateur dans le portail IAM
     * @return les details de cet utilisateur
     */
    AbstractIamDetails createIamDetails(AuthenticateProviderInterface authenticateProvider);
}
