package ch.vd.shared.iam.web.filter.auth;

import ch.vd.shared.iam.core.filter.auth.IamAuthority;

import java.util.Collection;

public class AuthenticateDtoProvider implements AuthenticateProviderInterface {

    private final AuthenticateDTO authenticateDTO;
    private final Collection<IamAuthority> allRoles;

    public AuthenticateDtoProvider(AuthenticateDTO authenticateDTO, Collection<IamAuthority> allRoles) {
        this.authenticateDTO = authenticateDTO;
        this.allRoles = allRoles;
    }

    @Override
    public Collection<IamAuthority> getIamRoles() {
        return allRoles;
    }

    @Override
    public String getIUP() {
        return authenticateDTO.getUsedPrincipal();
    }
}
