package ch.vd.shared.iam.web.filter.logout;

import ch.vd.shared.iam.web.utils.IamWebUtils;
import org.springframework.security.web.DefaultRedirectStrategy;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Plus de détails : voir https://portail.etat-de-vaud.ch/outils/dsiwiki/display/PlateformeIAM/IAM-AM
 * <p>
 * Redirect straegy qui utilise le header X-Forwarded-Host posé par IAM pour la redirection
 *
 * @author dgo
 */
public class ForwardedHostLogoutRedirectStrategy extends DefaultRedirectStrategy {

    @Override
    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        super.sendRedirect(request, response, IamWebUtils.calculateRedirect(request, url));
    }
}
