package ch.vd.shared.iam.web.filter.remote;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public final class RemoteHostHelper {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteHostHelper.class);

    private RemoteHostHelper() {
        throw new IllegalStateException("Nope class");
    }

    public static boolean hasMatch(String clientAddr, Pattern[] patterns) {
        for (Pattern p : patterns) {
            if (p.matcher(clientAddr).matches()) {
                return true;
            }
        }

        return false;
    }

    public static void handleInvalidAccess(ServletRequest request, ServletResponse response, String clientAddr) throws IOException {
        String url = ((HttpServletRequest) request).getRequestURL().toString();
        LOGGER.warn("Invalid access attempt to {} from {}", url, clientAddr);
        ((HttpServletResponse) response).sendError(HttpServletResponse.SC_FORBIDDEN);
    }

    public static Pattern[] parseParam(String param, boolean isRegex) {
        if (param == null || "".equals(param)) {
            return new Pattern[0];
        }

        String[] splitted = param.split(",");
        Pattern patterns[] = new Pattern[splitted.length];
        for (int i = 0, length = splitted.length; i < length; i++) {
            Pattern pat;
            if (!isRegex) {
                pat = Pattern.compile(wildcardToRegExp(splitted[i]));
            } else {
                pat = Pattern.compile(splitted[i]);
            }
            patterns[i] = pat;
        }

        return patterns;
    }

    /**
     * Cette méthode permet de convertir des adresses ip au format wildcard ("10.240.6.*") au format regexp ("10\.240\.6\.[.0-9]+")
     *
     * @param wildcard une adresse IP qui peut contenir des wildcards
     *
     * @return l'adresse IP convertie au format regexp
     */
    static String wildcardToRegExp(String wildcard) {
        return wildcard.replaceAll("\\.", "\\\\.").replaceAll("\\*", "[.0-9]+");
    }
}
