package ch.vd.shared.iam.web.filter.time;

import ch.vd.shared.iam.web.common.RequestHelper;
import ch.vd.shared.iam.web.filter.auth.IamRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class TimeRequestSpringFilter extends GenericFilterBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(TimeRequestSpringFilter.class);

    @Override
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {

        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) resp;

        IamRequestWrapper wrapper = new IamRequestWrapper(request);

        long begin = System.currentTimeMillis();
        boolean hasException = false;

        try {
            chain.doFilter(request, response);
        } catch (IOException | ServletException | RuntimeException e) {
            hasException = true;
            LOGGER.error("" + e, e);
            throw e;
        } finally {
            long diff = System.currentTimeMillis() - begin;
            StringBuilder str = new StringBuilder();
            if (hasException) {
                str.append("[EXCEPTION] ");
            }
            if (diff >= 1000) {
                // Secondes
                str.append(RequestHelper.normalize(String.format("%.3f[s]", (diff / 1000.0)), 8, true));
            } else {
                str.append(RequestHelper.normalize(String.format("%d[ms]", diff), 8, true));
            }

            String username = "non-auth";
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (auth != null) {
                username = auth.getName();
            }

            RequestHelper.logRequestInfos(wrapper, response, str.toString(), username);
        }
    }
}
