/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.core.filter.auth;

import ch.vd.shared.iam.core.filter.auth.AbstractIamAuthentication;
import ch.vd.shared.iam.core.filter.auth.IamAuthority;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamAuthentication
extends AbstractIamAuthentication {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final long serialVersionUID = 1L;
    private final String application;
    private final String email;
    private String principal;
    private String username;
    private String firstname;
    private String lastname;
    private final List<String> iamRoles = new ArrayList<String>();
    private Date lastLoginTime;
    private Integer authLevel;

    public IamAuthentication(String application, String principal, String username, String firstName, String lastName, String email, List<String> iamRoles, Integer authLevel, Date lastLoginTime, Collection<IamAuthority> allRoles) {
        super(allRoles);
        this.init(principal, username, iamRoles, authLevel, lastLoginTime);
        this.application = application;
        try {
            this.logger.debug("firstName : {}", (Object)firstName);
            this.logger.debug("lastName : {}", (Object)lastName);
            this.firstname = MimeUtility.decodeText((String)StringUtils.stripToEmpty((String)firstName));
            this.lastname = MimeUtility.decodeText((String)StringUtils.stripToEmpty((String)lastName));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.info("An error occured during MIME headers decoding. Fallback to old assignation for first name and last name");
            this.firstname = firstName;
            this.lastname = lastName;
        }
        this.email = email;
    }

    private void init(String principal, String username, List<String> roles, Integer authLevel, Date lastLoginTime) {
        this.principal = principal;
        this.username = username;
        this.authLevel = authLevel;
        this.lastLoginTime = lastLoginTime;
        if (roles != null) {
            this.iamRoles.addAll(roles);
        }
        this.setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return "";
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    @Override
    public String getIUP() {
        return this.getUsername();
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public String getFirstname() {
        return this.firstname;
    }

    @Override
    public String getLastname() {
        return this.lastname;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public Integer getAuthLevel() {
        return this.authLevel;
    }

    @Override
    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    @Override
    public List<String> getIamOriginalRoles() {
        return this.iamRoles;
    }

    @Override
    public Collection<IamAuthority> getAllRoles() {
        return this.getAuthorities();
    }

    @Override
    public boolean isStrongAuth() {
        return this.authLevel != null && this.authLevel == 20;
    }

    public String toString() {
        return "name=" + this.getPrincipal() + " firstName=" + this.getFirstname() + " lastName=" + this.getLastname() + " email=" + this.getEmail() + " iam-roles=" + this.getIamOriginalRoles();
    }
}

