/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.model.application;

import ch.vd.shared.iam.model.application.UsersFavoriteApplications;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="IAM_APPLICATION")
public class IamApplication {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="iamapplication_sequence")
    @SequenceGenerator(name="iamapplication_sequence", sequenceName="iam_application_id_seq", allocationSize=1)
    @Column(name="ID")
    private Long id;
    @Column(name="IS_VISIBLE")
    private Boolean isVisible = Boolean.FALSE;
    @Column(name="NAME")
    private String name;
    @Column(name="LABEL")
    private String label;
    @Column(name="URL")
    private String url;
    @Column(name="ACCESS_TYPE")
    private String accessType;
    @Column(name="MESSAGE", length=340)
    private String message;
    @Column(name="DATE_DEB_MESSAGE")
    private ZonedDateTime dateDebMessage;
    @Column(name="DATE_FIN_MESSAGE")
    private ZonedDateTime dateFinMessage;
    @Column(name="DATE_DEB_INDISPO")
    private ZonedDateTime dateDebIndispo;
    @Column(name="DATE_FIN_INDISPO")
    private ZonedDateTime dateFinIndispo;
    @Column(name="DATE_MODIF")
    private ZonedDateTime dateModif = ZonedDateTime.now(ZoneOffset.UTC);
    @Column(name="IUP_MODIF", length=20)
    private String iupModif;
    @JsonIgnore
    @OneToMany(mappedBy="iamApplication", cascade={CascadeType.REMOVE})
    private List<UsersFavoriteApplications> usersFavoriteApplications = new ArrayList<UsersFavoriteApplications>();

    public Long getId() {
        return this.id;
    }

    public Boolean getIsVisible() {
        return this.isVisible;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public String getMessage() {
        return this.message;
    }

    public ZonedDateTime getDateDebMessage() {
        return this.dateDebMessage;
    }

    public ZonedDateTime getDateFinMessage() {
        return this.dateFinMessage;
    }

    public ZonedDateTime getDateDebIndispo() {
        return this.dateDebIndispo;
    }

    public ZonedDateTime getDateFinIndispo() {
        return this.dateFinIndispo;
    }

    public ZonedDateTime getDateModif() {
        return this.dateModif;
    }

    public String getIupModif() {
        return this.iupModif;
    }

    public List<UsersFavoriteApplications> getUsersFavoriteApplications() {
        return this.usersFavoriteApplications;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setIsVisible(Boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDateDebMessage(ZonedDateTime dateDebMessage) {
        this.dateDebMessage = dateDebMessage;
    }

    public void setDateFinMessage(ZonedDateTime dateFinMessage) {
        this.dateFinMessage = dateFinMessage;
    }

    public void setDateDebIndispo(ZonedDateTime dateDebIndispo) {
        this.dateDebIndispo = dateDebIndispo;
    }

    public void setDateFinIndispo(ZonedDateTime dateFinIndispo) {
        this.dateFinIndispo = dateFinIndispo;
    }

    public void setDateModif(ZonedDateTime dateModif) {
        this.dateModif = dateModif;
    }

    public void setIupModif(String iupModif) {
        this.iupModif = iupModif;
    }

    public void setUsersFavoriteApplications(List<UsersFavoriteApplications> usersFavoriteApplications) {
        this.usersFavoriteApplications = usersFavoriteApplications;
    }
}

