/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ApplicationVersion {
    private static String version = null;
    private static String buildDate = null;
    private static Map<String, String> buildDateArray = null;

    public static String get() {
        if (version == null) {
            ApplicationVersion.readLines();
            version = buildDateArray.get("version");
        }
        return version;
    }

    public static String getBuildDate() {
        if (buildDate == null) {
            ApplicationVersion.readLines();
            buildDate = buildDateArray.get("buildDate");
        }
        return buildDate;
    }

    private static void readLines() {
        try (InputStream is = ApplicationVersion.class.getResourceAsStream("/version.txt");){
            ApplicationVersion.readLines(is);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Impossible de r\u00e9cup\u00e9rer la version de l'application", ioe);
        }
    }

    private static void readLines(InputStream is) throws IOException {
        if (buildDateArray == null) {
            Objects.requireNonNull(is, "Le fichier version.txt est introuvable");
            byte[] data = IOUtils.toByteArray((InputStream)is);
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
            HashMap<String, String> list = new HashMap<String, String>();
            String line = reader.readLine();
            while (line != null) {
                if (StringUtils.isNotBlank((CharSequence)line)) {
                    String[] parts = line.split("=");
                    if (parts.length > 1) {
                        list.put(parts[0], parts[1]);
                    } else {
                        list.put(parts[0], "");
                    }
                }
                line = reader.readLine();
            }
            buildDateArray = list;
        }
    }
}

