/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.web.common;

import ch.vd.shared.iam.core.filter.auth.IamAuthority;
import ch.vd.shared.iam.web.filter.auth.IamRequestWrapper;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class RequestHelper {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"iam.http.request");
    public static final Logger HEADER_LOGGER = LoggerFactory.getLogger((String)"iam.http.headers");

    public static void logRequestInfos(IamRequestWrapper request, HttpServletResponse response, String prefix, String username) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Collection auths = null;
        if (auth != null) {
            auths = auth.getAuthorities();
        }
        RequestHelper.logRequestInfos(request, response, prefix, username, auths);
    }

    public static void logRequestInfos(IamRequestWrapper request, HttpServletResponse response, String prefix, String username, Collection<IamAuthority> auths) {
        if (LOGGER.isDebugEnabled()) {
            String contextPath = request.getContextPath();
            String requestUri = request.getRequestURI();
            String url = requestUri.substring(contextPath.length());
            StringBuilder msg = new StringBuilder();
            msg.append(prefix).append(" '").append(RequestHelper.normalize(url, 30)).append("'");
            if (username != null) {
                msg.append(" by ").append(RequestHelper.normalize(username, 10));
            } else {
                msg.append(" not logged");
            }
            msg.append(" ").append(RequestHelper.normalize(request.getMethod(), 4));
            if (auths != null) {
                for (IamAuthority ga : auths) {
                    msg.append(" [").append(ga.getAuthority()).append("]");
                }
            }
            if (response != null && response.getContentType() != null) {
                msg.append(" ContentType:'").append(response.getContentType()).append("'");
            }
            msg.append(" Url:'").append(url).append("'");
            if (request.getParameterMap().size() > 0) {
                msg.append(" Params:");
                for (String name : request.getParameterMap().keySet()) {
                    String param = request.getParameter(name);
                    if (param != null) {
                        param = StringUtils.replace((String)param, (String)"\n", (String)"");
                        param = StringUtils.replace((String)param, (String)"\r", (String)"");
                    }
                    msg.append(" (" + name + ">'" + param + "')");
                }
            }
            LOGGER.debug("" + msg);
        }
    }

    public static String normalize(String in, int len) {
        return RequestHelper.normalize(in, len, false);
    }

    public static String normalize(String in, int len, boolean atBegin) {
        String out;
        if (in.length() > len) {
            out = in.substring(0, len);
        } else if (atBegin) {
            StringBuilder str = new StringBuilder(in);
            for (int i = in.length(); i < len; ++i) {
                str.insert(0, " ");
            }
            out = str.toString();
        } else {
            out = String.format("%1$-" + len + "s", in);
        }
        return out;
    }

    public static void dumpRequestForDebug(HttpServletRequest request) {
        if (HEADER_LOGGER.isDebugEnabled()) {
            Object value;
            String name;
            HEADER_LOGGER.debug("Request for: " + request.getRequestURL());
            Object enu = request.getHeaderNames();
            while (enu.hasMoreElements()) {
                name = (String)enu.nextElement();
                value = request.getHeader(name);
                HEADER_LOGGER.debug("Header: " + name + " => " + value);
            }
            for (Object key : request.getParameterMap().keySet()) {
                String toDump;
                value = request.getParameterMap().get(key);
                if (value == null) continue;
                if (value instanceof String[]) {
                    StringBuilder str = new StringBuilder();
                    for (String s : (String[])value) {
                        if (str.length() > 0) {
                            str.append(",");
                        }
                        str.append(s);
                    }
                    toDump = str.toString();
                } else {
                    toDump = value.toString();
                }
                HEADER_LOGGER.debug("Parameter: " + key + " => " + toDump);
            }
            enu = request.getAttributeNames();
            while (enu.hasMoreElements()) {
                name = (String)enu.nextElement();
                value = request.getAttribute(name);
                HEADER_LOGGER.debug("Attribute: " + name + " => " + value);
            }
            HEADER_LOGGER.debug("End Request " + request.getRequestURL());
        }
    }
}

