/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.web.filter.auth;

import ch.vd.shared.iam.core.filter.auth.AbstractIamDetails;
import ch.vd.shared.iam.core.filter.auth.IamAuthentication;
import ch.vd.shared.iam.core.filter.auth.IamAuthority;
import ch.vd.shared.iam.web.filter.auth.AdditionalInformationProvider;
import ch.vd.shared.iam.web.filter.auth.AuthenticateDTO;
import ch.vd.shared.iam.web.filter.auth.AuthenticateDtoProvider;
import ch.vd.shared.iam.web.filter.auth.IamRequestWrapper;
import ch.vd.shared.iam.web.utils.IamWebUtils;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public abstract class AbstractSharedIamAuthenticationFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSharedIamAuthenticationFilter.class);
    public static final String IAM_AUTH_SAVED_PATH = "iam-auth-saved-path";
    private AdditionalInformationProvider additionalProvider;

    static void relativeRedirect(IamRequestWrapper wrapper, HttpServletResponse response, String url) throws IOException {
        response.sendRedirect(IamWebUtils.calculateRedirect(wrapper.getRequest(), url));
    }

    protected void authenticate(AuthenticateDTO authenticateDTO) {
        Integer authLevel = authenticateDTO.getAuthLevelStr();
        Date lastLoginTime = IamWebUtils.parseIsoTime(authenticateDTO.getLastLoginTimeStr());
        SecurityContextHolder.clearContext();
        SecurityContext ctx = SecurityContextHolder.createEmptyContext();
        SecurityContextHolder.setContext((SecurityContext)ctx);
        List<String> iamRoles = IamWebUtils.parseRoles(authenticateDTO.getApplication(), authenticateDTO.getRolesStr());
        HashSet<IamAuthority> allRoles = new HashSet<IamAuthority>(IamWebUtils.convertToAuthority(iamRoles));
        AbstractIamDetails iamDetails = null;
        if (this.additionalProvider != null && (iamDetails = this.additionalProvider.createIamDetails(new AuthenticateDtoProvider(authenticateDTO, allRoles))) != null) {
            allRoles.addAll(iamDetails.getAdditionalRoles());
        }
        IamAuthentication auth = new IamAuthentication(authenticateDTO.getApplication(), authenticateDTO.getUsedPrincipal(), authenticateDTO.getUsername(), authenticateDTO.getFirstName(), authenticateDTO.getLastName(), authenticateDTO.getEmail(), iamRoles, authLevel, lastLoginTime, allRoles);
        auth.setDetails(iamDetails);
        ctx.setAuthentication((Authentication)auth);
    }

    protected String getUsernameForLog(IamRequestWrapper request) {
        String reqUsername = this.getUsedPrincipal(request);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String authUsername = auth != null ? auth.getName() : null;
        if (reqUsername != null) {
            return reqUsername;
        }
        if (authUsername != null) {
            return authUsername;
        }
        return "<unknown>";
    }

    protected String getUsedPrincipal(IamRequestWrapper request) {
        return request.getUserName();
    }

    public void setAdditionalProvider(AdditionalInformationProvider additionalProvider) {
        this.additionalProvider = additionalProvider;
    }
}

