/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.web.filter.auth;

import ch.vd.shared.iam.core.filter.auth.IamAuthentication;
import ch.vd.shared.iam.web.common.RequestHelper;
import ch.vd.shared.iam.web.filter.auth.AbstractSharedIamAuthenticationFilter;
import ch.vd.shared.iam.web.filter.auth.AuthenticateDTO;
import ch.vd.shared.iam.web.filter.auth.IamRequestWrapper;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class FormDevLoginSpringFilter
extends AbstractSharedIamAuthenticationFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDevLoginSpringFilter.class);
    public static final String DEV_LOGIN_USERNAME = "dl-username";
    public static final String DEV_LOGIN_ROLES = "dl-roles";
    public static final String DEV_LOGIN_FIRST = "dl-first";
    public static final String DEV_LOGIN_LAST = "dl-last";
    public static final String DEV_LOGIN_EMAIL = "dl-email";
    public static final String SPRING_SECURITY_URL = "/j_spring_security_check";
    private String successUrl;
    private String deniedUrl;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        IamRequestWrapper wrapper = new IamRequestWrapper(request);
        RequestHelper.dumpRequestForDebug(request);
        String contextPath = request.getContextPath();
        String requestUri = request.getRequestURI();
        String url = requestUri.substring(contextPath.length());
        Authentication givenAuth = SecurityContextHolder.getContext().getAuthentication();
        if (givenAuth != null && givenAuth.isAuthenticated()) {
            long begin = System.nanoTime();
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            long diff = System.nanoTime() - begin;
            response.addHeader("iamstats-app-response-time", "D=" + diff / 1000L);
        } else {
            boolean authSucess;
            String redirUrlForLog;
            if (url.endsWith(SPRING_SECURITY_URL)) {
                String username = request.getParameter(DEV_LOGIN_USERNAME);
                String rolesCommas = request.getParameter(DEV_LOGIN_ROLES);
                if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)rolesCommas)) {
                    String application = "dl-app";
                    String rolesStr = "";
                    for (String part : rolesCommas.split(",")) {
                        if (rolesStr.length() > 0) {
                            rolesStr = rolesStr + "|";
                        }
                        rolesStr = rolesStr + "cn=" + application + "-" + part + ",dc=etat-de-vaud,dc=ch";
                    }
                    LOGGER.info("Le devlogin est activ\u00e9. POST sur //j_spring_security_check avec " + username + " / " + rolesStr);
                    String firstName = request.getParameter(DEV_LOGIN_FIRST);
                    String lastName = request.getParameter(DEV_LOGIN_LAST);
                    String email = request.getParameter(DEV_LOGIN_EMAIL);
                    Objects.requireNonNull(firstName, "Pas de first name");
                    Objects.requireNonNull(lastName, "Pas de last name");
                    String authLevelStr = request.getParameter("iam-authlevel");
                    Integer authLevel = authLevelStr != null ? Integer.valueOf(Integer.parseInt(authLevelStr)) : null;
                    String lastLoginTime = request.getParameter("iam-lastlogin");
                    AuthenticateDTO dto = new AuthenticateDTO(username, username, application, rolesStr, firstName, lastName, email, authLevel, lastLoginTime);
                    this.authenticate(dto);
                    String query = (String)request.getSession().getAttribute("iam-auth-saved-path");
                    if (query != null) {
                        LOGGER.info("Le devlogin est successful. Redirection -> " + query);
                        response.sendRedirect(query);
                        redirUrlForLog = query;
                    } else {
                        LOGGER.info("Le devlogin est successful. Redirection -> " + this.successUrl);
                        FormDevLoginSpringFilter.relativeRedirect(wrapper, response, this.successUrl);
                        redirUrlForLog = this.successUrl;
                    }
                    authSucess = true;
                } else {
                    LOGGER.warn("Le devlogin est activ\u00e9, mais pas de username ni roles. Url='" + request.getRequestURI() + "' Redirection -> " + this.deniedUrl);
                    FormDevLoginSpringFilter.relativeRedirect(wrapper, response, this.deniedUrl);
                    redirUrlForLog = this.deniedUrl;
                    authSucess = false;
                }
            } else {
                FormDevLoginSpringFilter.relativeRedirect(wrapper, response, this.deniedUrl);
                redirUrlForLog = this.deniedUrl;
                authSucess = false;
            }
            IamAuthentication auth = (IamAuthentication)SecurityContextHolder.getContext().getAuthentication();
            if (authSucess) {
                RequestHelper.logRequestInfos(wrapper, response, "AUTH-OK Redirect to '" + redirUrlForLog + "'", this.getUsernameForLog(wrapper), auth != null ? auth.getAllRoles() : null);
            } else {
                RequestHelper.logRequestInfos(wrapper, response, "AUTH-KO Redirect to '" + redirUrlForLog + "'", this.getUsernameForLog(wrapper), auth != null ? auth.getAllRoles() : null);
            }
        }
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public void setDeniedUrl(String deniedUrl) {
        this.deniedUrl = deniedUrl;
    }
}

