/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.web.filter.auth;

import ch.vd.shared.iam.core.filter.auth.IamAuthentication;
import ch.vd.shared.iam.web.common.RequestHelper;
import ch.vd.shared.iam.web.filter.auth.AbstractSharedIamAuthenticationFilter;
import ch.vd.shared.iam.web.filter.auth.AuthenticateDTO;
import ch.vd.shared.iam.web.filter.auth.IamRequestWrapper;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class IamAuthenticationSpringFilter
extends AbstractSharedIamAuthenticationFilter
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(IamAuthenticationSpringFilter.class);
    private String failureUrl;

    public IamAuthenticationSpringFilter() {
        ((Object)((Object)this)).toString();
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.failureUrl), (String)"'failureUrl' must be set");
    }

    public void doFilter(ServletRequest r, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)r;
        HttpServletResponse response = (HttpServletResponse)resp;
        IamRequestWrapper wrapper = new IamRequestWrapper(req);
        RequestHelper.dumpRequestForDebug(req);
        this.invalidateHttpSessionIfNotsameBetweenIamAuthenticationAndRequest(wrapper, response);
        if (this.requiresAuthentication(wrapper)) {
            IamAuthentication auth = (IamAuthentication)SecurityContextHolder.getContext().getAuthentication();
            RequestHelper.logRequestInfos(wrapper, response, RequestHelper.normalize("NEED", 8), this.getUsernameForLog(wrapper), auth != null ? auth.getAllRoles() : null);
            boolean authSuccess = this.doAuthentication(wrapper, response);
            if (!authSuccess) {
                RequestHelper.logRequestInfos(wrapper, response, RequestHelper.normalize("AUTH-KO", 8), this.getUsernameForLog(wrapper), auth != null ? auth.getAllRoles() : null);
                return;
            }
            RequestHelper.logRequestInfos(wrapper, response, RequestHelper.normalize("AUTH-OK", 8), this.getUsernameForLog(wrapper), auth != null ? auth.getAllRoles() : null);
        }
        long begin = System.nanoTime();
        chain.doFilter((ServletRequest)req, (ServletResponse)response);
        long diff = System.nanoTime() - begin;
        response.addHeader("iamstats-app-response-time", "D=" + diff / 1000L);
    }

    private void invalidateHttpSessionIfNotsameBetweenIamAuthenticationAndRequest(IamRequestWrapper wrapper, HttpServletResponse response) {
        IamAuthentication auth = (IamAuthentication)SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.isAuthenticated()) {
            String reqUser = this.getUsedPrincipal(wrapper);
            String authUser = auth.getName();
            Integer authLevel = auth.getAuthLevel();
            boolean sameUser = Objects.equals(authUser, reqUser);
            boolean sameAuthLevel = Objects.equals(authLevel, wrapper.getAuthLevel());
            if (!sameUser || !sameAuthLevel) {
                wrapper.getSession().invalidate();
            }
        }
    }

    private boolean requiresAuthentication(IamRequestWrapper request) {
        boolean need;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            need = true;
        } else if (!auth.isAuthenticated()) {
            need = true;
        } else {
            String username = this.getUsedPrincipal(request);
            String principal = auth.getName();
            need = principal == null ? true : username != null && !principal.equals(username);
        }
        return need;
    }

    private boolean doAuthentication(IamRequestWrapper wrapper, HttpServletResponse response) throws IOException {
        SecurityContextHolder.clearContext();
        String username = wrapper.getUserName();
        String application = wrapper.getApplication();
        String rolesStr = wrapper.getRoles();
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)application)) {
            LOGGER.error("Il manque des headers dans la request -> redirige sur '{}' (username={}, application={})", new Object[]{this.failureUrl, username, application});
            String requestUri = wrapper.getRequestURI();
            wrapper.getSession().setAttribute("iam-auth-saved-path", (Object)requestUri);
            IamAuthenticationSpringFilter.relativeRedirect(wrapper, response, this.failureUrl);
            return false;
        }
        Integer authLevel = wrapper.getAuthLevel();
        String lastLoginStr = wrapper.getLastLogin();
        String email = wrapper.getEmail();
        String firstName = wrapper.getFirstName();
        String lastName = wrapper.getLastName();
        String usedPrincipal = this.getUsedPrincipal(wrapper);
        AuthenticateDTO authenticateDTO = new AuthenticateDTO(usedPrincipal, username, application, rolesStr, firstName, lastName, email, authLevel, lastLoginStr);
        this.authenticate(authenticateDTO);
        return true;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }
}

