/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.web.filter.auth;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class IamRequestWrapper {
    public static final String X_FORWARDED_HOST = "x-forwarded-host";
    public static final String HOST_TO_MATCH = "prestations.vd.ch";
    private final HttpServletRequest request;
    private Boolean isOriginACV = true;

    public IamRequestWrapper(HttpServletRequest request) {
        Objects.requireNonNull(request, "request cannot be null");
        this.request = request;
        this.isRequestFromACV(request);
    }

    private void isRequestFromACV(HttpServletRequest request) {
        String xForwardedForHeader = request.getHeader(X_FORWARDED_HOST);
        this.isOriginACV = null == xForwardedForHeader || !xForwardedForHeader.contains(HOST_TO_MATCH);
    }

    public Boolean getOriginACV() {
        return this.isOriginACV;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Map getParameterMap() {
        return this.request.getParameterMap();
    }

    public String getParameter(String p) {
        return this.request.getParameter(p);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public String getHeader(String header) {
        return this.request.getHeader(header);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getApplication() {
        return this.request.getHeader("iam-application");
    }

    public String getUserName() {
        return this.request.getHeader("iam-userid");
    }

    public String getRoles() {
        return this.request.getHeader("iam-roles");
    }

    public Integer getAuthLevel() {
        String authLevelStr = this.request.getHeader("iam-authlevel");
        if (StringUtils.isNotBlank((CharSequence)authLevelStr)) {
            return Integer.parseInt(authLevelStr);
        }
        return null;
    }

    public String getLastLogin() {
        return this.request.getHeader("iam-lastlogin");
    }

    public String getFirstName() {
        String headerValue = this.request.getHeader("iam-firstname");
        return this.isOriginACV != false ? IamRequestWrapper.isoToUtf8(headerValue) : headerValue;
    }

    public String getLastName() {
        String headerValue = this.request.getHeader("iam-lastname");
        return this.isOriginACV != false ? IamRequestWrapper.isoToUtf8(headerValue) : headerValue;
    }

    public String getEmail() {
        return this.request.getHeader("iam-email");
    }

    public static String isoToUtf8(String isoIn) {
        if (isoIn != null) {
            try {
                return new String(isoIn.getBytes("ISO8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }
}

