/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.web.filter.autorization;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

public class ByRoleUrlAutorizationSpringFilter
implements Filter,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByRoleUrlAutorizationSpringFilter.class);
    private static final int ACCESS_GRANTED = 1;
    private static final int ACCESS_DENIED = -1;
    public static final String IS_AUTHENTICATED_FULLY = "IS_AUTHENTICATED_FULLY";
    public static final String IS_ANONYMOUS = "IS_ANONYMOUS";
    public static final String IS_DENIED = "IS_DENIED";
    private FilterInvocationSecurityMetadataSource securityMetadataSource;

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }

    public void afterPropertiesSet() {
        Objects.requireNonNull(this.securityMetadataSource, "An SecurityMetadataSource is required");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        this.checkAutorization(fi);
        chain.doFilter(request, response);
    }

    protected void checkAutorization(FilterInvocation fi) {
        Authentication auth;
        Objects.requireNonNull(fi, "Object was null");
        boolean debug = LOGGER.isDebugEnabled();
        Collection attributes = this.securityMetadataSource.getAttributes((Object)fi);
        if (attributes == null) {
            throw new IllegalArgumentException("Secure object invocation " + fi + " was denied as public invocations are not allowed via this interceptor");
        }
        if (debug) {
            LOGGER.debug("Secure object: " + fi + "; Attributes: " + attributes);
        }
        if ((auth = SecurityContextHolder.getContext().getAuthentication()) == null) {
            this.credentialsNotFound("An Authentication object was not found in the SecurityContext", fi, attributes);
        }
        this.authorize(fi, auth, attributes);
        if (debug) {
            LOGGER.debug("Authorization successful");
        }
    }

    private void authorize(FilterInvocation fi, Authentication auth, Collection<ConfigAttribute> attributes) {
        Objects.requireNonNull(auth, "auth cannot be null");
        for (ConfigAttribute attribute : attributes) {
            if (IS_DENIED.equals(attribute.getAttribute())) {
                throw new AccessDeniedException("Access is denied");
            }
            if (IS_AUTHENTICATED_FULLY.equals(attribute.getAttribute()) && auth.isAuthenticated()) {
                return;
            }
            if (!IS_ANONYMOUS.equals(attribute.getAttribute())) continue;
            return;
        }
        int result = this.authorizeOnRoles(fi, auth, attributes);
        if (result == -1) {
            throw new AccessDeniedException("Access is denied");
        }
    }

    private int authorizeOnRoles(FilterInvocation fi, Authentication auth, Collection<ConfigAttribute> attributes) {
        int result = -1;
        Collection authorities = auth.getAuthorities();
        for (ConfigAttribute attribute : attributes) {
            result = -1;
            for (GrantedAuthority authority : authorities) {
                if (authority.getAuthority() == null || attribute.getAttribute() == null || !attribute.getAttribute().contains(authority.getAuthority())) continue;
                return 1;
            }
        }
        return result;
    }

    private void credentialsNotFound(String reason, Object secureObject, Collection<ConfigAttribute> configAttribs) {
        throw new AuthenticationCredentialsNotFoundException(reason);
    }

    public void setSecurityMetadataSource(FilterInvocationSecurityMetadataSource newSource) {
        this.securityMetadataSource = newSource;
    }
}

