/*
 * Decompiled with CFR 0.152.
 */
package ch.vd.shared.iam.web.filter.remote;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteHostHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteHostHelper.class);

    private RemoteHostHelper() {
        throw new IllegalStateException("Nope class");
    }

    public static boolean hasMatch(String clientAddr, Pattern[] patterns) {
        for (Pattern p : patterns) {
            if (!p.matcher(clientAddr).matches()) continue;
            return true;
        }
        return false;
    }

    public static void handleInvalidAccess(ServletRequest request, ServletResponse response, String clientAddr) throws IOException {
        String url = ((HttpServletRequest)request).getRequestURL().toString();
        LOGGER.warn("Invalid access attempt to {} from {}", (Object)url, (Object)clientAddr);
        ((HttpServletResponse)response).sendError(403);
    }

    public static Pattern[] parseParam(String param, boolean isRegex) {
        if (param == null || "".equals(param)) {
            return new Pattern[0];
        }
        String[] splitted = param.split(",");
        Pattern[] patterns = new Pattern[splitted.length];
        int length = splitted.length;
        for (int i = 0; i < length; ++i) {
            Pattern pat = !isRegex ? Pattern.compile(RemoteHostHelper.wildcardToRegExp(splitted[i])) : Pattern.compile(splitted[i]);
            patterns[i] = pat;
        }
        return patterns;
    }

    static String wildcardToRegExp(String wildcard) {
        return wildcard.replaceAll("\\.", "\\\\.").replaceAll("\\*", "[.0-9]+");
    }
}

